/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.util.ResourceGuard;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ResourceGuardTest
extends TestLogger {
    @Test
    public void testClose() {
        ResourceGuard resourceGuard = new ResourceGuard();
        Assert.assertFalse((boolean)resourceGuard.isClosed());
        resourceGuard.close();
        Assert.assertTrue((boolean)resourceGuard.isClosed());
        try {
            resourceGuard.acquireResource();
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testAcquireReleaseClose() throws IOException {
        ResourceGuard resourceGuard = new ResourceGuard();
        ResourceGuard.Lease lease = resourceGuard.acquireResource();
        Assert.assertEquals((long)1L, (long)resourceGuard.getLeaseCount());
        lease.close();
        Assert.assertEquals((long)0L, (long)resourceGuard.getLeaseCount());
        resourceGuard.close();
        Assert.assertTrue((boolean)resourceGuard.isClosed());
    }

    @Test
    public void testCloseBlockIfAcquired() throws Exception {
        final ResourceGuard resourceGuard = new ResourceGuard();
        ResourceGuard.Lease lease = resourceGuard.acquireResource();
        final AtomicBoolean checker = new AtomicBoolean(true);
        Thread closerThread = new Thread(){

            @Override
            public void run() {
                resourceGuard.close();
                checker.set(false);
            }
        };
        closerThread.start();
        while (!resourceGuard.isClosed()) {
            Thread.yield();
        }
        Assert.assertTrue((boolean)checker.get());
        try {
            resourceGuard.acquireResource();
            Assert.fail((String)"Resource guard is expected to be already closed.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        lease.close();
        closerThread.join(60000L);
        Assert.assertFalse((boolean)checker.get());
    }

    @Test
    public void testInterruptHandledCorrectly() throws Exception {
        final ResourceGuard resourceGuard = new ResourceGuard();
        ResourceGuard.Lease lease = resourceGuard.acquireResource();
        final AtomicBoolean checker = new AtomicBoolean(true);
        Thread closerThread = new Thread(){

            @Override
            public void run() {
                resourceGuard.close();
                checker.set(false);
            }
        };
        closerThread.start();
        while (!resourceGuard.isClosed()) {
            Thread.yield();
        }
        closerThread.interrupt();
        closerThread.join(100L);
        Assert.assertTrue((boolean)checker.get());
        lease.close();
        closerThread.join(60000L);
        Assert.assertFalse((boolean)checker.get());
    }

    @Test
    public void testLeaseCloseIsIdempotent() throws Exception {
        ResourceGuard resourceGuard = new ResourceGuard();
        ResourceGuard.Lease lease1 = resourceGuard.acquireResource();
        ResourceGuard.Lease lease2 = resourceGuard.acquireResource();
        Assert.assertEquals((long)2L, (long)resourceGuard.getLeaseCount());
        lease1.close();
        Assert.assertEquals((long)1L, (long)resourceGuard.getLeaseCount());
        lease1.close();
        Assert.assertEquals((long)1L, (long)resourceGuard.getLeaseCount());
        lease2.close();
        Assert.assertEquals((long)0L, (long)resourceGuard.getLeaseCount());
        ResourceGuard.Lease lease3 = resourceGuard.acquireResource();
        Assert.assertEquals((long)1L, (long)resourceGuard.getLeaseCount());
        lease2.close();
        Assert.assertEquals((long)1L, (long)resourceGuard.getLeaseCount());
        lease3.close();
        Assert.assertEquals((long)0L, (long)resourceGuard.getLeaseCount());
        resourceGuard.close();
    }
}

