/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.eventtime.RecordTimestampAssigner;
import org.apache.flink.api.common.eventtime.SerializableTimestampAssigner;
import org.apache.flink.api.common.eventtime.TimestampAssigner;
import org.apache.flink.api.common.eventtime.TimestampAssignerSupplier;
import org.apache.flink.api.common.eventtime.WatermarkAlignmentParams;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.eventtime.WatermarksWithIdleness;
import org.apache.flink.api.common.eventtime.WatermarksWithWatermarkAlignment;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricGroup;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class WatermarkStrategyTest {
    @Test
    public void testDefaultTimeStampAssigner() {
        WatermarkStrategy wmStrategy = WatermarkStrategy.forMonotonousTimestamps();
        ClosureCleaner.clean((Object)wmStrategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        Assert.assertThat((Object)wmStrategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext()), (Matcher)CoreMatchers.instanceOf(RecordTimestampAssigner.class));
    }

    @Test
    public void testLambdaTimestampAssigner() {
        WatermarkStrategy wmStrategy = WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(event, timestamp) -> 42L);
        ClosureCleaner.clean((Object)wmStrategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        TimestampAssigner timestampAssigner = wmStrategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext());
        Assert.assertThat((Object)timestampAssigner.extractTimestamp(null, 13L), (Matcher)CoreMatchers.is((Object)42L));
    }

    @Test
    public void testLambdaTimestampAssignerSupplier() {
        WatermarkStrategy wmStrategy = WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner(TimestampAssignerSupplier.of((SerializableTimestampAssigner & Serializable)(event, timestamp) -> 42L));
        ClosureCleaner.clean((Object)wmStrategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        TimestampAssigner timestampAssigner = wmStrategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext());
        Assert.assertThat((Object)timestampAssigner.extractTimestamp(null, 13L), (Matcher)CoreMatchers.is((Object)42L));
    }

    @Test
    public void testAnonymousInnerTimestampAssigner() {
        WatermarkStrategy wmStrategy = WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((SerializableTimestampAssigner)new SerializableTimestampAssigner<Object>(){

            public long extractTimestamp(Object element, long recordTimestamp) {
                return 42L;
            }
        });
        ClosureCleaner.clean((Object)wmStrategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        TimestampAssigner timestampAssigner = wmStrategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext());
        Assert.assertThat((Object)timestampAssigner.extractTimestamp(null, 13L), (Matcher)CoreMatchers.is((Object)42L));
    }

    @Test
    public void testClassTimestampAssigner() {
        WatermarkStrategy wmStrategy = WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((TimestampAssignerSupplier & Serializable)ctx -> new TestTimestampAssigner());
        ClosureCleaner.clean((Object)wmStrategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        TimestampAssigner timestampAssigner = wmStrategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext());
        Assert.assertThat((Object)timestampAssigner.extractTimestamp(null, 13L), (Matcher)CoreMatchers.is((Object)42L));
    }

    @Test
    public void testClassTimestampAssignerUsingSupplier() {
        WatermarkStrategy wmStrategy = WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((TimestampAssignerSupplier & Serializable)context -> new TestTimestampAssigner());
        ClosureCleaner.clean((Object)wmStrategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        TimestampAssigner timestampAssigner = wmStrategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext());
        Assert.assertThat((Object)timestampAssigner.extractTimestamp(null, 13L), (Matcher)CoreMatchers.is((Object)42L));
    }

    @Test
    public void testWithIdlenessHelper() {
        WatermarkStrategy wmStrategy = WatermarkStrategy.forMonotonousTimestamps().withIdleness(Duration.ofDays(7L));
        ClosureCleaner.clean((Object)wmStrategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        Assert.assertThat((Object)wmStrategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext()), (Matcher)CoreMatchers.instanceOf(RecordTimestampAssigner.class));
        Assert.assertThat((Object)wmStrategy.createWatermarkGenerator(WatermarkStrategyTest.generatorContext()), (Matcher)CoreMatchers.instanceOf(WatermarksWithIdleness.class));
    }

    @Test
    public void testWithWatermarkAlignment() {
        String watermarkGroup = "group-1";
        Duration maxAllowedWatermarkDrift = Duration.ofMillis(200L);
        WatermarkStrategy strategy = WatermarkStrategy.forMonotonousTimestamps().withWatermarkAlignment("group-1", maxAllowedWatermarkDrift).withIdleness(Duration.ofMillis(200L));
        ClosureCleaner.clean((Object)strategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        WatermarkAlignmentParams alignmentParameters = strategy.getAlignmentParameters();
        Assert.assertThat((Object)alignmentParameters.getWatermarkGroup(), (Matcher)CoreMatchers.equalTo((Object)"group-1"));
        Assert.assertThat((Object)alignmentParameters.getMaxAllowedWatermarkDrift(), (Matcher)CoreMatchers.equalTo((Object)maxAllowedWatermarkDrift.toMillis()));
        Assert.assertThat((Object)alignmentParameters.getUpdateInterval(), (Matcher)CoreMatchers.equalTo((Object)WatermarksWithWatermarkAlignment.DEFAULT_UPDATE_INTERVAL.toMillis()));
        Assert.assertThat((Object)strategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext()), (Matcher)CoreMatchers.instanceOf(RecordTimestampAssigner.class));
        Assert.assertThat((Object)strategy.createWatermarkGenerator(WatermarkStrategyTest.generatorContext()), (Matcher)CoreMatchers.instanceOf(WatermarksWithIdleness.class));
    }

    static TimestampAssignerSupplier.Context assignerContext() {
        return new TimestampAssignerSupplier.Context(){

            public MetricGroup getMetricGroup() {
                return new DummyMetricGroup();
            }
        };
    }

    static WatermarkGeneratorSupplier.Context generatorContext() {
        return new WatermarkGeneratorSupplier.Context(){

            public MetricGroup getMetricGroup() {
                return new DummyMetricGroup();
            }
        };
    }

    public static class DummyMetricGroup
    implements MetricGroup {
        public Counter counter(String name) {
            return null;
        }

        public <C extends Counter> C counter(String name, C counter) {
            return null;
        }

        public <T, G extends Gauge<T>> G gauge(String name, G gauge) {
            return null;
        }

        public <H extends Histogram> H histogram(String name, H histogram) {
            return null;
        }

        public <M extends Meter> M meter(String name, M meter) {
            return null;
        }

        public MetricGroup addGroup(String name) {
            return null;
        }

        public MetricGroup addGroup(String key, String value) {
            return null;
        }

        public String[] getScopeComponents() {
            return new String[0];
        }

        public Map<String, String> getAllVariables() {
            return null;
        }

        public String getMetricIdentifier(String metricName) {
            return null;
        }

        public String getMetricIdentifier(String metricName, CharacterFilter filter) {
            return null;
        }
    }

    static class TestTimestampAssigner
    implements TimestampAssigner<Object>,
    Serializable {
        TestTimestampAssigner() {
        }

        public long extractTimestamp(Object element, long recordTimestamp) {
            return 42L;
        }
    }
}

