/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.io.DelimitedInputFormatTest;
import org.apache.flink.api.common.io.GenericCsvInputFormat;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GenericCsvInputFormatTest {
    private TestCsvInputFormat format;

    @Before
    public void setup() {
        this.format = new TestCsvInputFormat();
        this.format.setFilePath("file:///some/file/that/will/not/be/read");
    }

    @After
    public void setdown() throws Exception {
        if (this.format != null) {
            this.format.close();
        }
    }

    @Test
    public void testSparseFieldArray() {
        Object[] originalTypes = new Class[]{IntValue.class, null, null, StringValue.class, null, DoubleValue.class};
        this.format.setFieldTypesGeneric((Class[])originalTypes);
        Assert.assertEquals((long)3L, (long)this.format.getNumberOfNonNullFields());
        Assert.assertEquals((long)6L, (long)this.format.getNumberOfFieldsTotal());
        Assert.assertTrue((boolean)Arrays.equals(originalTypes, this.format.getGenericFieldTypes()));
    }

    @Test
    public void testReadNoPosAll() throws IOException {
        try {
            String fileContent = "111|222|333|444|555\n666|777|888|999|000|";
            FileInputSplit split = DelimitedInputFormatTest.createTempFile("111|222|333|444|555\n666|777|888|999|000|");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldTypesGeneric(new Class[]{IntValue.class, IntValue.class, IntValue.class, IntValue.class, IntValue.class});
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = this.createIntValues(5);
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)111L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)222L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)333L, (long)((IntValue)values[2]).getValue());
            Assert.assertEquals((long)444L, (long)((IntValue)values[3]).getValue());
            Assert.assertEquals((long)555L, (long)((IntValue)values[4]).getValue());
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)666L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)777L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)888L, (long)((IntValue)values[2]).getValue());
            Assert.assertEquals((long)999L, (long)((IntValue)values[3]).getValue());
            Assert.assertEquals((long)0L, (long)((IntValue)values[4]).getValue());
            Assert.assertNull((Object)this.format.nextRecord(values));
            Assert.assertTrue((boolean)this.format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadNoPosAllDeflate() throws IOException {
        try {
            String fileContent = "111|222|333|444|555\n666|777|888|999|000|";
            FileInputSplit split = this.createTempDeflateFile("111|222|333|444|555\n666|777|888|999|000|");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldTypesGeneric(new Class[]{IntValue.class, IntValue.class, IntValue.class, IntValue.class, IntValue.class});
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = this.createIntValues(5);
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)111L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)222L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)333L, (long)((IntValue)values[2]).getValue());
            Assert.assertEquals((long)444L, (long)((IntValue)values[3]).getValue());
            Assert.assertEquals((long)555L, (long)((IntValue)values[4]).getValue());
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)666L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)777L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)888L, (long)((IntValue)values[2]).getValue());
            Assert.assertEquals((long)999L, (long)((IntValue)values[3]).getValue());
            Assert.assertEquals((long)0L, (long)((IntValue)values[4]).getValue());
            Assert.assertNull((Object)this.format.nextRecord(values));
            Assert.assertTrue((boolean)this.format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadNoPosAllGzip() throws IOException {
        try {
            String fileContent = "111|222|333|444|555\n666|777|888|999|000|";
            FileInputSplit split = this.createTempGzipFile("111|222|333|444|555\n666|777|888|999|000|");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldTypesGeneric(new Class[]{IntValue.class, IntValue.class, IntValue.class, IntValue.class, IntValue.class});
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = this.createIntValues(5);
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)111L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)222L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)333L, (long)((IntValue)values[2]).getValue());
            Assert.assertEquals((long)444L, (long)((IntValue)values[3]).getValue());
            Assert.assertEquals((long)555L, (long)((IntValue)values[4]).getValue());
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)666L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)777L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)888L, (long)((IntValue)values[2]).getValue());
            Assert.assertEquals((long)999L, (long)((IntValue)values[3]).getValue());
            Assert.assertEquals((long)0L, (long)((IntValue)values[4]).getValue());
            Assert.assertNull((Object)this.format.nextRecord(values));
            Assert.assertTrue((boolean)this.format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadNoPosAllZStandard() throws IOException {
        try {
            String fileContent = "111|222|333|444|555\n666|777|888|999|000|";
            FileInputSplit split = this.createTempZStandardFile("111|222|333|444|555\n666|777|888|999|000|");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldTypesGeneric(new Class[]{IntValue.class, IntValue.class, IntValue.class, IntValue.class, IntValue.class});
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = this.createIntValues(5);
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)111L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)222L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)333L, (long)((IntValue)values[2]).getValue());
            Assert.assertEquals((long)444L, (long)((IntValue)values[3]).getValue());
            Assert.assertEquals((long)555L, (long)((IntValue)values[4]).getValue());
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)666L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)777L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)888L, (long)((IntValue)values[2]).getValue());
            Assert.assertEquals((long)999L, (long)((IntValue)values[3]).getValue());
            Assert.assertEquals((long)0L, (long)((IntValue)values[4]).getValue());
            Assert.assertNull((Object)this.format.nextRecord(values));
            Assert.assertTrue((boolean)this.format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadNoPosFirstN() throws IOException {
        try {
            String fileContent = "111|222|333|444|555|\n666|777|888|999|000|";
            FileInputSplit split = DelimitedInputFormatTest.createTempFile("111|222|333|444|555|\n666|777|888|999|000|");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldTypesGeneric(new Class[]{IntValue.class, IntValue.class});
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = this.createIntValues(2);
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)111L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)222L, (long)((IntValue)values[1]).getValue());
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)666L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)777L, (long)((IntValue)values[1]).getValue());
            Assert.assertNull((Object)this.format.nextRecord(values));
            Assert.assertTrue((boolean)this.format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testSparseParse() {
        try {
            String fileContent = "111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|";
            FileInputSplit split = DelimitedInputFormatTest.createTempFile("111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldTypesGeneric(new Class[]{IntValue.class, null, null, IntValue.class, null, null, null, IntValue.class});
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = this.createIntValues(3);
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)111L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)444L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)888L, (long)((IntValue)values[2]).getValue());
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)0L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)777L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)333L, (long)((IntValue)values[2]).getValue());
            Assert.assertNull((Object)this.format.nextRecord(values));
            Assert.assertTrue((boolean)this.format.reachedEnd());
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            Assert.fail((String)"Test erroneous");
        }
    }

    @Test
    public void testLongLongLong() {
        try {
            String fileContent = "1,2,3\n3,2,1";
            FileInputSplit split = DelimitedInputFormatTest.createTempFile("1,2,3\n3,2,1");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter(",");
            this.format.setFieldTypesGeneric(new Class[]{LongValue.class, LongValue.class, LongValue.class});
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = this.createLongValues(3);
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)1L, (long)((LongValue)values[0]).getValue());
            Assert.assertEquals((long)2L, (long)((LongValue)values[1]).getValue());
            Assert.assertEquals((long)3L, (long)((LongValue)values[2]).getValue());
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)3L, (long)((LongValue)values[0]).getValue());
            Assert.assertEquals((long)2L, (long)((LongValue)values[1]).getValue());
            Assert.assertEquals((long)1L, (long)((LongValue)values[2]).getValue());
            Assert.assertNull((Object)this.format.nextRecord(values));
            Assert.assertTrue((boolean)this.format.reachedEnd());
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            Assert.fail((String)"Test erroneous");
        }
    }

    @Test
    public void testSparseParseWithIndices() {
        try {
            String fileContent = "111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|";
            FileInputSplit split = DelimitedInputFormatTest.createTempFile("111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldsGeneric(new int[]{0, 3, 7}, new Class[]{IntValue.class, IntValue.class, IntValue.class});
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = this.createIntValues(3);
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)111L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)444L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)888L, (long)((IntValue)values[2]).getValue());
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)0L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)777L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)333L, (long)((IntValue)values[2]).getValue());
            Assert.assertNull((Object)this.format.nextRecord(values));
            Assert.assertTrue((boolean)this.format.reachedEnd());
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            Assert.fail((String)"Test erroneous");
        }
    }

    @Test
    public void testSparseParseWithIndicesMultiCharDelimiter() {
        try {
            String fileContent = "111|-|222|-|333|-|444|-|555|-|666|-|777|-|888|-|999|-|000|-|\n000|-|999|-|888|-|777|-|666|-|555|-|444|-|333|-|222|-|111\n555|-|999|-|888|-|111|-|666|-|555|-|444|-|777|-|222|-|111|-|\n22222|-|99999|-|8|-|99999999|-|6666666|-|5|-|4444|-|8|-|22222|-|1\n";
            FileInputSplit split = DelimitedInputFormatTest.createTempFile("111|-|222|-|333|-|444|-|555|-|666|-|777|-|888|-|999|-|000|-|\n000|-|999|-|888|-|777|-|666|-|555|-|444|-|333|-|222|-|111\n555|-|999|-|888|-|111|-|666|-|555|-|444|-|777|-|222|-|111|-|\n22222|-|99999|-|8|-|99999999|-|6666666|-|5|-|4444|-|8|-|22222|-|1\n");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|-|");
            this.format.setFieldsGeneric(new int[]{0, 3, 7}, new Class[]{IntValue.class, IntValue.class, IntValue.class});
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = this.createIntValues(3);
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)111L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)444L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)888L, (long)((IntValue)values[2]).getValue());
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)0L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)777L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)333L, (long)((IntValue)values[2]).getValue());
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)555L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)111L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)777L, (long)((IntValue)values[2]).getValue());
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((long)22222L, (long)((IntValue)values[0]).getValue());
            Assert.assertEquals((long)99999999L, (long)((IntValue)values[1]).getValue());
            Assert.assertEquals((long)8L, (long)((IntValue)values[2]).getValue());
            Assert.assertNull((Object)this.format.nextRecord(values));
            Assert.assertTrue((boolean)this.format.reachedEnd());
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            Assert.fail((String)"Test erroneous");
        }
    }

    @Test
    public void testReadTooShortInput() throws IOException {
        try {
            String fileContent = "111|222|333|444\n666|777|888|999";
            FileInputSplit split = DelimitedInputFormatTest.createTempFile("111|222|333|444\n666|777|888|999");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldTypesGeneric(new Class[]{IntValue.class, IntValue.class, IntValue.class, IntValue.class, IntValue.class});
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = this.createIntValues(5);
            try {
                this.format.nextRecord(values);
                Assert.fail((String)"Should have thrown a parse exception on too short input.");
            }
            catch (ParseException parseException) {}
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadTooShortInputLenient() throws IOException {
        try {
            String fileContent = "666|777|888|999|555\n111|222|333|444\n666|777|888|999|555";
            FileInputSplit split = DelimitedInputFormatTest.createTempFile("666|777|888|999|555\n111|222|333|444\n666|777|888|999|555");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldTypesGeneric(new Class[]{IntValue.class, IntValue.class, IntValue.class, IntValue.class, IntValue.class});
            this.format.setLenient(true);
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = this.createIntValues(5);
            Assert.assertNotNull((Object)this.format.nextRecord(values));
            Assert.assertNull((Object)this.format.nextRecord(values));
            Assert.assertNotNull((Object)this.format.nextRecord(values));
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadInvalidContents() throws IOException {
        try {
            String fileContent = "abc|222|def|444\nkkz|777|888|hhg";
            FileInputSplit split = DelimitedInputFormatTest.createTempFile("abc|222|def|444\nkkz|777|888|hhg");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldTypesGeneric(new Class[]{StringValue.class, IntValue.class, StringValue.class, IntValue.class});
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = new Value[]{new StringValue(), new IntValue(), new StringValue(), new IntValue()};
            Assert.assertNotNull((Object)this.format.nextRecord(values));
            try {
                this.format.nextRecord(values);
                Assert.fail((String)"Input format accepted on invalid input.");
            }
            catch (ParseException parseException) {}
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadInvalidContentsLenient() {
        try {
            String fileContent = "abc|222|def|444\nkkz|777|888|hhg";
            FileInputSplit split = DelimitedInputFormatTest.createTempFile("abc|222|def|444\nkkz|777|888|hhg");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldTypesGeneric(new Class[]{StringValue.class, IntValue.class, StringValue.class, IntValue.class});
            this.format.setLenient(true);
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = new Value[]{new StringValue(), new IntValue(), new StringValue(), new IntValue()};
            Assert.assertNotNull((Object)this.format.nextRecord(values));
            Assert.assertNull((Object)this.format.nextRecord(values));
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadInvalidContentsLenientWithSkipping() {
        try {
            String fileContent = "abc|dfgsdf|777|444\nkkz|777|foobar|hhg\nkkz|777foobarhhg  \nxyx|ignored|42|\n";
            FileInputSplit split = DelimitedInputFormatTest.createTempFile("abc|dfgsdf|777|444\nkkz|777|foobar|hhg\nkkz|777foobarhhg  \nxyx|ignored|42|\n");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldTypesGeneric(new Class[]{StringValue.class, null, IntValue.class});
            this.format.setLenient(true);
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = new Value[]{new StringValue(), new IntValue()};
            Assert.assertNotNull((Object)this.format.nextRecord(values));
            Assert.assertNull((Object)this.format.nextRecord(values));
            Assert.assertNull((Object)this.format.nextRecord(values));
            Assert.assertNotNull((Object)this.format.nextRecord(values));
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void testReadWithCharset() throws IOException {
        Object[] records = new String[]{"\u020e\u021f", "Flink", "\u020b\u020f"};
        String delimiter = "\u05c0\u05c0";
        String fileContent = StringUtils.join((Object[])records, (String)delimiter);
        GenericCsvInputFormat<String[]> format = new GenericCsvInputFormat<String[]>(){

            public String[] readRecord(String[] target, byte[] bytes, int offset, int numBytes) throws IOException {
                return this.parseRecord(target, bytes, offset, numBytes) ? target : null;
            }
        };
        format.setFilePath("file:///some/file/that/will/not/be/read");
        for (String charset : new String[]{"UTF-8", "UTF-16BE", "UTF-16LE"}) {
            File tempFile = File.createTempFile("test_contents", "tmp");
            tempFile.deleteOnExit();
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), charset);){
                out.write(fileContent);
            }
            FileInputSplit split = new FileInputSplit(0, new Path(tempFile.toURI().toString()), 0L, tempFile.length(), new String[]{"localhost"});
            format.setFieldDelimiter(delimiter);
            format.setFieldTypesGeneric(new Class[]{String.class, String.class, String.class});
            format.setCharset(charset);
            format.configure(new Configuration());
            format.open(split);
            String[] values = new String[]{"", "", ""};
            values = (String[])format.nextRecord((Object)values);
            Assert.assertNotNull((Object)values);
            for (int i = 0; i < records.length; ++i) {
                Assert.assertEquals((Object)records[i], (Object)values[i]);
            }
            Assert.assertNull((Object)format.nextRecord((Object)values));
            Assert.assertTrue((boolean)format.reachedEnd());
        }
        format.close();
    }

    @Test
    public void readWithEmptyField() {
        try {
            String fileContent = "abc|def|ghijk\nabc||hhg\n|||";
            FileInputSplit split = DelimitedInputFormatTest.createTempFile("abc|def|ghijk\nabc||hhg\n|||");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldTypesGeneric(new Class[]{StringValue.class, StringValue.class, StringValue.class});
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = new Value[]{new StringValue(), new StringValue(), new StringValue()};
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((Object)"abc", (Object)((StringValue)values[0]).getValue());
            Assert.assertEquals((Object)"def", (Object)((StringValue)values[1]).getValue());
            Assert.assertEquals((Object)"ghijk", (Object)((StringValue)values[2]).getValue());
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((Object)"abc", (Object)((StringValue)values[0]).getValue());
            Assert.assertEquals((Object)"", (Object)((StringValue)values[1]).getValue());
            Assert.assertEquals((Object)"hhg", (Object)((StringValue)values[2]).getValue());
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((Object)"", (Object)((StringValue)values[0]).getValue());
            Assert.assertEquals((Object)"", (Object)((StringValue)values[1]).getValue());
            Assert.assertEquals((Object)"", (Object)((StringValue)values[2]).getValue());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void readWithParseQuotedStrings() {
        try {
            String fileContent = "\"ab\\\"c\"|\"def\"\n\"ghijk\"|\"abc\"";
            FileInputSplit split = DelimitedInputFormatTest.createTempFile("\"ab\\\"c\"|\"def\"\n\"ghijk\"|\"abc\"");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldTypesGeneric(new Class[]{StringValue.class, StringValue.class});
            this.format.enableQuotedStringParsing('\"');
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = new Value[]{new StringValue(), new StringValue()};
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((Object)"ab\\\"c", (Object)((StringValue)values[0]).getValue());
            Assert.assertEquals((Object)"def", (Object)((StringValue)values[1]).getValue());
            values = (Value[])this.format.nextRecord(values);
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((Object)"ghijk", (Object)((StringValue)values[0]).getValue());
            Assert.assertEquals((Object)"abc", (Object)((StringValue)values[1]).getValue());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void readWithHeaderLine() {
        try {
            String fileContent = "colname-1|colname-2|some name 3|column four|\n123|abc|456|def|\n987|xyz|654|pqr|\n";
            FileInputSplit split = DelimitedInputFormatTest.createTempFile("colname-1|colname-2|some name 3|column four|\n123|abc|456|def|\n987|xyz|654|pqr|\n");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldTypesGeneric(new Class[]{IntValue.class, StringValue.class, IntValue.class, StringValue.class});
            this.format.setSkipFirstLineAsHeader(true);
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = new Value[]{new IntValue(), new StringValue(), new IntValue(), new StringValue()};
            Assert.assertNotNull((Object)this.format.nextRecord(values));
            Assert.assertNotNull((Object)this.format.nextRecord(values));
            Assert.assertNull((Object)this.format.nextRecord(values));
            Assert.assertTrue((boolean)this.format.reachedEnd());
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    @Test
    public void readWithHeaderLineAndInvalidIntermediate() {
        try {
            String fileContent = "colname-1|colname-2|some name 3|column four|\n123|abc|456|def|\ncolname-1|colname-2|some name 3|column four|\n987|xyz|654|pqr|\n";
            FileInputSplit split = DelimitedInputFormatTest.createTempFile("colname-1|colname-2|some name 3|column four|\n123|abc|456|def|\ncolname-1|colname-2|some name 3|column four|\n987|xyz|654|pqr|\n");
            Configuration parameters = new Configuration();
            this.format.setFieldDelimiter("|");
            this.format.setFieldTypesGeneric(new Class[]{IntValue.class, StringValue.class, IntValue.class, StringValue.class});
            this.format.setSkipFirstLineAsHeader(true);
            this.format.configure(parameters);
            this.format.open(split);
            Value[] values = new Value[]{new IntValue(), new StringValue(), new IntValue(), new StringValue()};
            Assert.assertNotNull((Object)this.format.nextRecord(values));
            try {
                this.format.nextRecord(values);
                Assert.fail((String)"Format accepted invalid line.");
            }
            catch (ParseException parseException) {}
        }
        catch (Exception ex) {
            Assert.fail((String)("Test failed due to a " + ex.getClass().getSimpleName() + ": " + ex.getMessage()));
        }
    }

    private FileInputSplit createTempDeflateFile(String content) throws IOException {
        File tempFile = File.createTempFile("test_contents", "tmp.deflate");
        tempFile.deleteOnExit();
        DataOutputStream dos = new DataOutputStream(new DeflaterOutputStream(new FileOutputStream(tempFile)));
        dos.writeBytes(content);
        dos.close();
        return new FileInputSplit(0, new Path(tempFile.toURI().toString()), 0L, tempFile.length(), new String[]{"localhost"});
    }

    private FileInputSplit createTempGzipFile(String content) throws IOException {
        File tempFile = File.createTempFile("test_contents", "tmp.gz");
        tempFile.deleteOnExit();
        DataOutputStream dos = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(tempFile)));
        dos.writeBytes(content);
        dos.close();
        return new FileInputSplit(0, new Path(tempFile.toURI().toString()), 0L, tempFile.length(), new String[]{"localhost"});
    }

    private FileInputSplit createTempZStandardFile(String content) throws IOException {
        File tempFile = File.createTempFile("test_contents", "tmp.zst");
        tempFile.deleteOnExit();
        DataOutputStream dos = new DataOutputStream((OutputStream)new ZstdCompressorOutputStream((OutputStream)new FileOutputStream(tempFile)));
        dos.writeBytes(content);
        dos.close();
        return new FileInputSplit(0, new Path(tempFile.toURI().toString()), 0L, tempFile.length(), new String[]{"localhost"});
    }

    private Value[] createIntValues(int num) {
        Value[] v = new Value[num];
        for (int i = 0; i < num; ++i) {
            v[i] = new IntValue();
        }
        return v;
    }

    private Value[] createLongValues(int num) {
        Value[] v = new Value[num];
        for (int i = 0; i < num; ++i) {
            v[i] = new LongValue();
        }
        return v;
    }

    private static final class TestCsvInputFormat
    extends GenericCsvInputFormat<Value[]> {
        private static final long serialVersionUID = 2653609265252951059L;

        private TestCsvInputFormat() {
        }

        public Value[] readRecord(Value[] target, byte[] bytes, int offset, int numBytes) {
            return this.parseRecord(target, bytes, offset, numBytes) ? target : null;
        }
    }
}

