/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.Serializable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ReducingStateDescriptorTest
extends TestLogger {
    @Test
    public void testReducingStateDescriptor() throws Exception {
        ReduceFunction & Serializable reducer = (ReduceFunction & Serializable)(a, b) -> a;
        KryoSerializer serializer = new KryoSerializer(String.class, (SerializerConfig)new SerializerConfigImpl());
        ReducingStateDescriptor descr = new ReducingStateDescriptor("testName", (ReduceFunction)reducer, (TypeSerializer)serializer);
        Assert.assertEquals((Object)"testName", (Object)descr.getName());
        Assert.assertNotNull((Object)descr.getSerializer());
        Assert.assertEquals((Object)serializer, (Object)descr.getSerializer());
        Assert.assertEquals((Object)reducer, (Object)descr.getReduceFunction());
        ReducingStateDescriptor copy = (ReducingStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)descr);
        Assert.assertEquals((Object)"testName", (Object)copy.getName());
        Assert.assertNotNull((Object)copy.getSerializer());
        Assert.assertEquals((Object)serializer, (Object)copy.getSerializer());
    }

    @Test
    public void testHashCodeEquals() throws Exception {
        String name = "testName";
        ReduceFunction & Serializable reducer = (ReduceFunction & Serializable)(a, b) -> a;
        ReducingStateDescriptor original = new ReducingStateDescriptor("testName", (ReduceFunction)reducer, String.class);
        ReducingStateDescriptor same = new ReducingStateDescriptor("testName", (ReduceFunction)reducer, String.class);
        ReducingStateDescriptor sameBySerializer = new ReducingStateDescriptor("testName", (ReduceFunction)reducer, (TypeSerializer)StringSerializer.INSTANCE);
        Assert.assertEquals((long)original.hashCode(), (long)same.hashCode());
        Assert.assertEquals((long)original.hashCode(), (long)sameBySerializer.hashCode());
        Assert.assertEquals((Object)original, (Object)same);
        Assert.assertEquals((Object)original, (Object)sameBySerializer);
        ReducingStateDescriptor clone = (ReducingStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)original);
        Assert.assertEquals((Object)original, (Object)clone);
        clone.initializeSerializerUnlessSet(new ExecutionConfig());
        Assert.assertEquals((Object)original, (Object)clone);
        original.initializeSerializerUnlessSet(new ExecutionConfig());
        Assert.assertEquals((Object)original, (Object)same);
    }
}

