/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.Serializable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ValueStateDescriptorTest
extends TestLogger {
    @Test
    public void testHashCodeEquals() throws Exception {
        String name = "testName";
        ValueStateDescriptor original = new ValueStateDescriptor("testName", String.class);
        ValueStateDescriptor same = new ValueStateDescriptor("testName", String.class);
        ValueStateDescriptor sameBySerializer = new ValueStateDescriptor("testName", (TypeSerializer)StringSerializer.INSTANCE);
        Assert.assertEquals((long)original.hashCode(), (long)same.hashCode());
        Assert.assertEquals((long)original.hashCode(), (long)sameBySerializer.hashCode());
        Assert.assertEquals((Object)original, (Object)same);
        Assert.assertEquals((Object)original, (Object)sameBySerializer);
        ValueStateDescriptor clone = (ValueStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)original);
        Assert.assertEquals((Object)original, (Object)clone);
        clone.initializeSerializerUnlessSet(new ExecutionConfig());
        Assert.assertEquals((Object)original, (Object)clone);
        original.initializeSerializerUnlessSet(new ExecutionConfig());
        Assert.assertEquals((Object)original, (Object)same);
    }

    @Test
    public void testVeryLargeDefaultValue() throws Exception {
        KryoSerializer serializer = new KryoSerializer(String.class, (SerializerConfig)new SerializerConfigImpl());
        byte[] data = new byte[200000];
        for (int i = 0; i < 200000; ++i) {
            data[i] = 65;
        }
        data[199000] = 0;
        String defaultValue = new String(data, ConfigConstants.DEFAULT_CHARSET);
        ValueStateDescriptor descr = new ValueStateDescriptor("testName", (TypeSerializer)serializer, (Object)defaultValue);
        Assert.assertEquals((Object)"testName", (Object)descr.getName());
        Assert.assertEquals((Object)defaultValue, (Object)descr.getDefaultValue());
        Assert.assertNotNull((Object)descr.getSerializer());
        Assert.assertEquals((Object)serializer, (Object)descr.getSerializer());
        ValueStateDescriptor copy = (ValueStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)descr);
        Assert.assertEquals((Object)"testName", (Object)copy.getName());
        Assert.assertEquals((Object)defaultValue, (Object)copy.getDefaultValue());
        Assert.assertNotNull((Object)copy.getSerializer());
        Assert.assertEquals((Object)serializer, (Object)copy.getSerializer());
    }
}

