/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
public abstract class TypeInformationTestBase<T extends TypeInformation<?>> {
    protected abstract T[] getTestData();

    @Test
    void testHashcodeAndEquals() throws Exception {
        TypeInformation[] testData = this.getTestData();
        UnrelatedTypeInfo unrelatedTypeInfo = new UnrelatedTypeInfo();
        for (TypeInformation typeInfo : testData) {
            if (typeInfo.getClass().getMethod("hashCode", new Class[0]).getDeclaringClass() == Object.class) {
                throw new AssertionError((Object)("Type information does not implement own hashCode method: " + typeInfo.getClass().getCanonicalName()));
            }
            if (typeInfo.getClass().getMethod("equals", Object.class).getDeclaringClass() == Object.class) {
                throw new AssertionError((Object)("Type information does not implement own equals method: " + typeInfo.getClass().getCanonicalName()));
            }
            for (TypeInformation otherTypeInfo : testData) {
                if (typeInfo == otherTypeInfo) {
                    ((AbstractIntegerAssert)Assertions.assertThat((int)typeInfo.hashCode()).as("hashCode() returns inconsistent results.", new Object[0])).isEqualTo(otherTypeInfo.hashCode());
                    ((ObjectAssert)Assertions.assertThat((Object)typeInfo).as("equals() is false for same object.", new Object[0])).isEqualTo((Object)otherTypeInfo);
                    continue;
                }
                ((ObjectAssert)Assertions.assertThat((Object)typeInfo).as("equals() returned true for different objects.", new Object[0])).isNotEqualTo((Object)otherTypeInfo);
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)typeInfo.canEqual((Object)unrelatedTypeInfo)).as("Type information allows to compare with unrelated type.", new Object[0])).isFalse();
            Assertions.assertThat((Object)typeInfo).isNotEqualTo((Object)unrelatedTypeInfo);
        }
    }

    @Test
    public void testSerialization() {
        TypeInformation[] testData;
        for (TypeInformation typeInfo : testData = this.getTestData()) {
            TypeInformation deserialized;
            byte[] serialized;
            try {
                serialized = InstantiationUtil.serializeObject((Object)typeInfo);
            }
            catch (IOException e) {
                throw new AssertionError("Could not serialize type information: " + typeInfo, e);
            }
            try {
                deserialized = (TypeInformation)InstantiationUtil.deserializeObject((byte[])serialized, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (IOException | ClassNotFoundException e) {
                throw new AssertionError("Could not deserialize type information: " + typeInfo, e);
            }
            if (typeInfo.hashCode() != deserialized.hashCode() || !typeInfo.equals((Object)deserialized)) {
                throw new AssertionError((Object)"Deserialized type information differs from original one.");
            }
        }
    }

    @Test
    public void testGetTotalFields() {
        TypeInformation[] testData;
        for (TypeInformation typeInfo : testData = this.getTestData()) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)typeInfo.getTotalFields()).as("Number of total fields must be at least 1", new Object[0])).isGreaterThan(0);
        }
    }

    private static class UnrelatedTypeInfo
    extends TypeInformation<Object> {
        private UnrelatedTypeInfo() {
        }

        public boolean isBasicType() {
            return false;
        }

        public boolean isTupleType() {
            return false;
        }

        public int getArity() {
            return 0;
        }

        public int getTotalFields() {
            return 0;
        }

        public Class<Object> getTypeClass() {
            return null;
        }

        public boolean isKeyType() {
            return false;
        }

        public TypeSerializer<Object> createSerializer(SerializerConfig config) {
            return null;
        }

        public TypeSerializer<Object> createSerializer(ExecutionConfig config) {
            return this.createSerializer(config.getSerializerConfig());
        }

        public String toString() {
            return null;
        }

        public boolean equals(Object obj) {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public boolean canEqual(Object obj) {
            return false;
        }
    }
}

