/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.util.function.Predicate;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.util.Preconditions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.TypeSafeMatcher;

public final class TypeSerializerMatchers {
    private TypeSerializerMatchers() {
    }

    public static <T> Matcher<TypeSerializerSchemaCompatibility<T>> isCompatibleAsIs() {
        return TypeSerializerMatchers.propertyMatcher(TypeSerializerSchemaCompatibility::isCompatibleAsIs, "type serializer schema that is a compatible as is");
    }

    public static <T> Matcher<TypeSerializerSchemaCompatibility<T>> isIncompatible() {
        return TypeSerializerMatchers.propertyMatcher(TypeSerializerSchemaCompatibility::isIncompatible, "type serializer schema that is incompatible");
    }

    public static <T> Matcher<TypeSerializerSchemaCompatibility<T>> isCompatibleAfterMigration() {
        return TypeSerializerMatchers.propertyMatcher(TypeSerializerSchemaCompatibility::isCompatibleAfterMigration, "type serializer schema that is compatible after migration");
    }

    public static <T> Matcher<TypeSerializerSchemaCompatibility<T>> isCompatibleWithReconfiguredSerializer() {
        Matcher anything = CoreMatchers.anything();
        return new CompatibleAfterReconfiguration(anything);
    }

    public static <T> Matcher<TypeSerializerSchemaCompatibility<T>> isCompatibleWithReconfiguredSerializer(Matcher<? extends TypeSerializer<T>> reconfiguredSerializerMatcher) {
        return new CompatibleAfterReconfiguration(reconfiguredSerializerMatcher);
    }

    public static <T> Matcher<TypeSerializerSchemaCompatibility<T>> hasSameCompatibilityAs(TypeSerializerSchemaCompatibility<T> expectedCompatibility) {
        return new SchemaCompatibilitySameAs(expectedCompatibility);
    }

    private static <T> Matcher<T> propertyMatcher(final Predicate<T> predicate, final String matcherDescription) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T item) {
                return predicate.test(item);
            }

            public void describeTo(Description description) {
                description.appendText(matcherDescription);
            }
        };
    }

    private static class SchemaCompatibilitySameAs<T>
    extends TypeSafeMatcher<TypeSerializerSchemaCompatibility<T>> {
        private final TypeSerializerSchemaCompatibility<T> expectedCompatibility;

        private SchemaCompatibilitySameAs(TypeSerializerSchemaCompatibility<T> expectedCompatibility) {
            this.expectedCompatibility = (TypeSerializerSchemaCompatibility)Preconditions.checkNotNull(expectedCompatibility);
        }

        protected boolean matchesSafely(TypeSerializerSchemaCompatibility<T> testResultCompatibility) {
            if (this.expectedCompatibility.isCompatibleAsIs()) {
                return testResultCompatibility.isCompatibleAsIs();
            }
            if (this.expectedCompatibility.isIncompatible()) {
                return testResultCompatibility.isIncompatible();
            }
            if (this.expectedCompatibility.isCompatibleAfterMigration()) {
                return testResultCompatibility.isCompatibleAfterMigration();
            }
            if (this.expectedCompatibility.isCompatibleWithReconfiguredSerializer()) {
                return testResultCompatibility.isCompatibleWithReconfiguredSerializer();
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("same compatibility as ").appendValue(this.expectedCompatibility);
        }
    }

    private static final class CompatibleAfterReconfiguration<T>
    extends TypeSafeDiagnosingMatcher<TypeSerializerSchemaCompatibility<T>> {
        private final Matcher<? extends TypeSerializer<T>> reconfiguredSerializerMatcher;

        private CompatibleAfterReconfiguration(Matcher<? extends TypeSerializer<T>> reconfiguredSerializerMatcher) {
            this.reconfiguredSerializerMatcher = (Matcher)Preconditions.checkNotNull(reconfiguredSerializerMatcher);
        }

        protected boolean matchesSafely(TypeSerializerSchemaCompatibility<T> item, Description mismatchDescription) {
            if (!item.isCompatibleWithReconfiguredSerializer()) {
                mismatchDescription.appendText("serializer schema is not compatible with a reconfigured serializer");
                return false;
            }
            TypeSerializer reconfiguredSerializer = item.getReconfiguredSerializer();
            if (!this.reconfiguredSerializerMatcher.matches((Object)reconfiguredSerializer)) {
                this.reconfiguredSerializerMatcher.describeMismatch((Object)reconfiguredSerializer, mismatchDescription);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("type serializer schema that is compatible after reconfiguration,").appendText("with a reconfigured serializer matching ").appendDescriptionOf(this.reconfiguredSerializerMatcher);
        }
    }
}

