/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TypeSerializerSnapshotTest {
    @Test
    public void testIllegalSchemaCompatibility() {
        NotCompletedTypeSerializerSnapshot illegalSnapshot = new NotCompletedTypeSerializerSnapshot(){};
        Assertions.assertThatThrownBy(() -> illegalSnapshot.resolveSchemaCompatibility(new NotCompletedTypeSerializer())).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> illegalSnapshot.resolveSchemaCompatibility(new NotCompletedTypeSerializer().snapshotConfiguration())).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testNewSchemaCompatibility() {
        final NotCompletedTypeSerializerSnapshot legalSnapshot = new NotCompletedTypeSerializerSnapshot(){

            public TypeSerializerSchemaCompatibility<Integer> resolveSchemaCompatibility(TypeSerializerSnapshot<Integer> oldSerializerSnapshot) {
                return TypeSerializerSchemaCompatibility.compatibleAsIs();
            }
        };
        Assertions.assertThat((boolean)new NotCompletedTypeSerializerSnapshot().resolveSchemaCompatibility(new NotCompletedTypeSerializer(){

            @Override
            public TypeSerializerSnapshot<Integer> snapshotConfiguration() {
                return legalSnapshot;
            }
        }).isCompatibleAsIs()).isTrue();
        Assertions.assertThat((boolean)legalSnapshot.resolveSchemaCompatibility(new NotCompletedTypeSerializerSnapshot(){}).isCompatibleAsIs()).isTrue();
    }

    @Test
    public void testOldSchemaCompatibility() {
        NotCompletedTypeSerializerSnapshot legalSnapshot = new NotCompletedTypeSerializerSnapshot(){

            public TypeSerializerSchemaCompatibility<Integer> resolveSchemaCompatibility(TypeSerializer<Integer> newSerializer) {
                return TypeSerializerSchemaCompatibility.compatibleAsIs();
            }
        };
        Assertions.assertThat((boolean)legalSnapshot.resolveSchemaCompatibility(new NotCompletedTypeSerializer()).isCompatibleAsIs()).isTrue();
        Assertions.assertThat((boolean)new NotCompletedTypeSerializerSnapshot().resolveSchemaCompatibility(legalSnapshot).isCompatibleAsIs()).isTrue();
    }

    @Test
    public void testNestedSchemaCompatibility() {
        final NotCompletedTypeSerializerSnapshot innerSnapshot = new NotCompletedTypeSerializerSnapshot(){

            public TypeSerializerSchemaCompatibility<Integer> resolveSchemaCompatibility(TypeSerializerSnapshot<Integer> oldSerializerSnapshot) {
                return TypeSerializerSchemaCompatibility.compatibleAsIs();
            }
        };
        NotCompletedTypeSerializerSnapshot outerSnapshot = new NotCompletedTypeSerializerSnapshot(){

            public TypeSerializerSchemaCompatibility<Integer> resolveSchemaCompatibility(TypeSerializer<Integer> newSerializer) {
                return innerSnapshot.resolveSchemaCompatibility(innerSnapshot.restoreSerializer());
            }
        };
        Assertions.assertThat((boolean)outerSnapshot.resolveSchemaCompatibility(outerSnapshot).isCompatibleAsIs()).isTrue();
    }

    private static class NotCompletedTypeSerializerSnapshot
    implements TypeSerializerSnapshot<Integer> {
        private NotCompletedTypeSerializerSnapshot() {
        }

        public int getCurrentVersion() {
            return 0;
        }

        public void writeSnapshot(DataOutputView out) {
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) {
        }

        public TypeSerializer<Integer> restoreSerializer() {
            return new NotCompletedTypeSerializer(){

                @Override
                public TypeSerializerSnapshot<Integer> snapshotConfiguration() {
                    return this;
                }
            };
        }
    }

    private static class NotCompletedTypeSerializer
    extends TypeSerializer<Integer> {
        private NotCompletedTypeSerializer() {
        }

        public boolean isImmutableType() {
            return true;
        }

        public TypeSerializer<Integer> duplicate() {
            return this;
        }

        public Integer createInstance() {
            return 0;
        }

        public Integer copy(Integer from) {
            return from;
        }

        public Integer copy(Integer from, Integer reuse) {
            return from;
        }

        public int getLength() {
            return 1;
        }

        public void serialize(Integer record, DataOutputView target) {
        }

        public Integer deserialize(DataInputView source) {
            return 0;
        }

        public Integer deserialize(Integer reuse, DataInputView source) {
            return reuse;
        }

        public void copy(DataInputView source, DataOutputView target) {
        }

        public boolean equals(Object obj) {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public TypeSerializerSnapshot<Integer> snapshotConfiguration() {
            return new NotCompletedTypeSerializerSnapshot(){

                @Override
                public TypeSerializer<Integer> restoreSerializer() {
                    return this;
                }
            };
        }
    }
}

