/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.array.BooleanPrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.CharPrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.DoublePrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.FloatPrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.IntPrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.LongPrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.ShortPrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.StringArraySerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class PrimitiveArraySerializerUpgradeTestSpecifications {

    public static final class PrimitiveStringArrayVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<String[]> {
        @Override
        public TypeSerializer<String[]> createUpgradedSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(String[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), StringArraySerializer.class);
            return serializer;
        }

        @Override
        public Matcher<String[]> testDataMatcher() {
            String[] data = new String[10];
            for (int i = 0; i < data.length; ++i) {
                data[i] = String.valueOf(i);
            }
            return Matchers.is((Object)data);
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<String[]>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class PrimitiveStringArraySetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<String[]> {
        @Override
        public TypeSerializer<String[]> createPriorSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(String[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), StringArraySerializer.class);
            return serializer;
        }

        @Override
        public String[] createTestData() {
            String[] data = new String[10];
            for (int i = 0; i < data.length; ++i) {
                data[i] = String.valueOf(i);
            }
            return data;
        }
    }

    public static final class PrimitiveShortArrayVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<short[]> {
        @Override
        public TypeSerializer<short[]> createUpgradedSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(short[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), ShortPrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public Matcher<short[]> testDataMatcher() {
            short[] data = new short[10];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (short)i;
            }
            return Matchers.is((Object)data);
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<short[]>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class PrimitiveShortArraySetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<short[]> {
        @Override
        public TypeSerializer<short[]> createPriorSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(short[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), ShortPrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public short[] createTestData() {
            short[] data = new short[10];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (short)i;
            }
            return data;
        }
    }

    public static final class PrimitiveLongArrayVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<long[]> {
        @Override
        public TypeSerializer<long[]> createUpgradedSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(long[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), LongPrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public Matcher<long[]> testDataMatcher() {
            long[] data = new long[10];
            for (int i = 0; i < data.length; ++i) {
                data[i] = i;
            }
            return Matchers.is((Object)data);
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<long[]>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class PrimitiveLongArraySetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<long[]> {
        @Override
        public TypeSerializer<long[]> createPriorSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(long[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), LongPrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public long[] createTestData() {
            long[] data = new long[10];
            for (int i = 0; i < data.length; ++i) {
                data[i] = i;
            }
            return data;
        }
    }

    public static final class PrimitiveIntArrayVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<int[]> {
        @Override
        public TypeSerializer<int[]> createUpgradedSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(int[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), IntPrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public Matcher<int[]> testDataMatcher() {
            int[] data = new int[10];
            for (int i = 0; i < data.length; ++i) {
                data[i] = i;
            }
            return Matchers.is((Object)data);
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<int[]>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class PrimitiveIntArraySetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<int[]> {
        @Override
        public TypeSerializer<int[]> createPriorSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(int[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), IntPrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public int[] createTestData() {
            int[] data = new int[10];
            for (int i = 0; i < data.length; ++i) {
                data[i] = i;
            }
            return data;
        }
    }

    public static final class PrimitiveFloatArrayVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<float[]> {
        @Override
        public TypeSerializer<float[]> createUpgradedSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(float[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), FloatPrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public Matcher<float[]> testDataMatcher() {
            float[] data = new float[10];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (float)i + 0.2f;
            }
            return Matchers.is((Object)data);
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<float[]>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class PrimitiveFloatArraySetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<float[]> {
        @Override
        public TypeSerializer<float[]> createPriorSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(float[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), FloatPrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public float[] createTestData() {
            float[] data = new float[10];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (float)i + 0.2f;
            }
            return data;
        }
    }

    public static final class PrimitiveDoubleArrayVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<double[]> {
        @Override
        public TypeSerializer<double[]> createUpgradedSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(double[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), DoublePrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public Matcher<double[]> testDataMatcher() {
            double[] data = new double[10];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (float)i + 0.1f;
            }
            return Matchers.is((Object)data);
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<double[]>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class PrimitiveDoubleArraySetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<double[]> {
        @Override
        public TypeSerializer<double[]> createPriorSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(double[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), DoublePrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public double[] createTestData() {
            double[] data = new double[10];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (float)i + 0.1f;
            }
            return data;
        }
    }

    public static final class PrimitiveCharArrayVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<char[]> {
        @Override
        public TypeSerializer<char[]> createUpgradedSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(char[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), CharPrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public Matcher<char[]> testDataMatcher() {
            char[] data = new char[10];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (char)i;
            }
            return Matchers.is((Object)data);
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<char[]>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class PrimitiveCharArraySetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<char[]> {
        @Override
        public TypeSerializer<char[]> createPriorSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(char[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), CharPrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public char[] createTestData() {
            char[] data = new char[10];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (char)i;
            }
            return data;
        }
    }

    public static final class PrimitiveByteArrayVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<byte[]> {
        @Override
        public TypeSerializer<byte[]> createUpgradedSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(byte[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), BytePrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public Matcher<byte[]> testDataMatcher() {
            byte[] expected = new byte[10];
            for (int i = 0; i < expected.length; ++i) {
                expected[i] = (byte)i;
            }
            return Matchers.is((Object)expected);
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<byte[]>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class PrimitiveByteArraySetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<byte[]> {
        @Override
        public TypeSerializer<byte[]> createPriorSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(byte[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), BytePrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public byte[] createTestData() {
            byte[] dummy = new byte[10];
            for (int i = 0; i < dummy.length; ++i) {
                dummy[i] = (byte)i;
            }
            return dummy;
        }
    }

    public static final class PrimitiveBooleanArrayVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<boolean[]> {
        @Override
        public TypeSerializer<boolean[]> createUpgradedSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(boolean[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), BooleanPrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public Matcher<boolean[]> testDataMatcher() {
            boolean[] expected = new boolean[]{true, false};
            return Matchers.is((Object)expected);
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<boolean[]>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class PrimitiveBooleanArraySetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<boolean[]> {
        @Override
        public TypeSerializer<boolean[]> createPriorSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(boolean[].class).createSerializer((SerializerConfig)new SerializerConfigImpl());
            Assert.assertSame(serializer.getClass(), BooleanPrimitiveArraySerializer.class);
            return serializer;
        }

        @Override
        public boolean[] createTestData() {
            boolean[] data = new boolean[]{true, false};
            return data;
        }
    }
}

