/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.tuple;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.apache.flink.util.FileUtils;

class TupleGenerator {
    private static final String ROOT_DIRECTORY = "./flink-core/src/main/java";
    private static final String PACKAGE = "org.apache.flink.api.java.tuple";
    private static final String BUILDER_SUFFIX = "builder";
    private static final String GEN_TYPE_PREFIX = "T";
    private static final String SETTER_ARG_NAME = "f";
    private static final String BEGIN_INDICATOR = "BEGIN_OF_TUPLE_DEPENDENT_CODE";
    private static final String END_INDICATOR = "END_OF_TUPLE_DEPENDENT_CODE";
    private static final String TUPLE_PACKAGE = "org.apache.flink.api.java.tuple";
    private static final String TUPLE_CLASSNAME = "Tuple";
    private static final int FIRST = 1;
    private static final int LAST = 25;
    private static final String HEADER = "/*\n * Licensed to the Apache Software Foundation (ASF) under one\n * or more contributor license agreements.  See the NOTICE file\n * distributed with this work for additional information\n * regarding copyright ownership.  The ASF licenses this file\n * to you under the Apache License, Version 2.0 (the\n * \"License\"); you may not use this file except in compliance\n * with the License.  You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n// --------------------------------------------------------------\n//  THIS IS A GENERATED SOURCE FILE. DO NOT EDIT!\n//  GENERATED FROM " + TupleGenerator.class.getName() + ".\n// --------------------------------------------------------------\n\n";

    TupleGenerator() {
    }

    public static void main(String[] args) throws Exception {
        System.err.println("Current directory " + System.getProperty("user.dir"));
        String rootDir = ROOT_DIRECTORY;
        if (args.length > 0) {
            rootDir = args[0] + "/" + ROOT_DIRECTORY;
        }
        System.err.println("Using root directory: " + rootDir);
        File root = new File(rootDir);
        TupleGenerator.createTupleClasses(root);
        TupleGenerator.createTupleBuilderClasses(root);
        TupleGenerator.modifyTupleType(root);
    }

    private static File getPackage(File root, String packageString) {
        File dir = new File(root, packageString.replace('.', '/'));
        if (!dir.exists() && dir.isDirectory()) {
            System.err.println("None existent directory: " + dir.getAbsolutePath());
            System.exit(1);
        }
        return dir;
    }

    private static void insertCodeIntoFile(String code, File file) throws IOException {
        String fileContent = FileUtils.readFileUtf8((File)file);
        try (Scanner s = new Scanner(fileContent);){
            String line;
            StringBuilder sb = new StringBuilder();
            boolean indicatorFound = false;
            while (s.hasNextLine() && (line = s.nextLine()) != null) {
                sb.append(line).append("\n");
                if (!line.contains(BEGIN_INDICATOR)) continue;
                indicatorFound = true;
                break;
            }
            if (!indicatorFound) {
                System.out.println("No indicator found in '" + file + "'. Will skip code generation.");
                s.close();
                return;
            }
            sb.append("\t// GENERATED FROM ").append(TupleGenerator.class.getName()).append(".\n");
            sb.append(code).append("\n");
            while (s.hasNextLine() && (line = s.nextLine()) != null) {
                if (!line.contains(END_INDICATOR)) continue;
                sb.append(line).append("\n");
                break;
            }
            while (s.hasNextLine() && (line = s.nextLine()) != null) {
                sb.append(line).append("\n");
            }
            FileUtils.writeFileUtf8((File)file, (String)sb.toString());
        }
    }

    private static void modifyTupleType(File root) throws IOException {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("\tpublic static Tuple newInstance(int arity) {\n");
        sb.append("\t\tswitch (arity) {\n");
        sb.append("\t\t\tcase 0: return Tuple0.INSTANCE;\n");
        for (i = 1; i <= 25; ++i) {
            sb.append("\t\t\tcase ").append(i).append(": return new Tuple").append(i).append("();\n");
        }
        sb.append("\t\t\tdefault: throw new IllegalArgumentException(\"The tuple arity must be in [0, \" + MAX_ARITY + \"].\");\n");
        sb.append("\t\t}\n");
        sb.append("\t}\n\n");
        sb.append("\tprivate static final Class<?>[] CLASSES = new Class<?>[] {\n\t\tTuple0.class");
        for (i = 1; i <= 25; ++i) {
            sb.append(", Tuple").append(i).append(".class");
        }
        sb.append("\n\t};");
        File dir = TupleGenerator.getPackage(root, "org.apache.flink.api.java.tuple");
        File tupleTypeInfoClass = new File(dir, "Tuple.java");
        TupleGenerator.insertCodeIntoFile(sb.toString(), tupleTypeInfoClass);
    }

    private static void createTupleClasses(File root) throws FileNotFoundException {
        File dir = TupleGenerator.getPackage(root, "org.apache.flink.api.java.tuple");
        for (int i = 1; i <= 25; ++i) {
            File tupleFile = new File(dir, TUPLE_CLASSNAME + i + ".java");
            PrintWriter writer = new PrintWriter(tupleFile);
            TupleGenerator.writeTupleClass(writer, i);
            writer.flush();
            writer.close();
        }
    }

    private static void writeTupleClass(PrintWriter w, int numFields) {
        int i;
        String field;
        int i2;
        int i3;
        String className = TUPLE_CLASSNAME + numFields;
        w.print(HEADER);
        w.println("package org.apache.flink.api.java.tuple;");
        w.println();
        w.println("import org.apache.flink.annotation.Public;");
        w.println("import org.apache.flink.util.StringUtils;");
        w.println();
        w.println("/**");
        w.println(" * A tuple with " + numFields + " fields. Tuples are strongly typed; each field may be of a separate type.");
        w.println(" * The fields of the tuple can be accessed directly as public fields (f0, f1, ...) or via their position");
        w.println(" * through the {@link #getField(int)} method. The tuple field positions start at zero.");
        w.println(" *");
        w.println(" * <p>Tuples are mutable types, meaning that their fields can be re-assigned. This allows functions that work");
        w.println(" * with Tuples to reuse objects in order to reduce pressure on the garbage collector.</p>");
        w.println(" *");
        w.println(" * <p>Warning: If you subclass " + className + ", then be sure to either <ul>");
        w.println(" *  <li> not add any new fields, or </li>");
        w.println(" *  <li> make it a POJO, and always declare the element type of your DataStreams/DataSets to your descendant");
        w.println(" *       type. (That is, if you have a \"class Foo extends " + className + "\", then don't use instances of");
        w.println(" *       Foo in a DataStream&lt;" + className + "&gt; / DataSet&lt;" + className + "&gt;, but declare it as");
        w.println(" *       DataStream&lt;Foo&gt; / DataSet&lt;Foo&gt;.) </li>");
        w.println(" * </ul></p>");
        w.println(" * @see Tuple");
        w.println(" *");
        for (i3 = 0; i3 < numFields; ++i3) {
            w.println(" * @param <T" + i3 + "> The type of field " + i3);
        }
        w.println(" */");
        w.println("@Public");
        w.print("public class " + className + "<");
        for (i3 = 0; i3 < numFields; ++i3) {
            if (i3 > 0) {
                w.print(", ");
            }
            w.print(GEN_TYPE_PREFIX + i3);
        }
        w.println("> extends Tuple {");
        w.println();
        w.println("\tprivate static final long serialVersionUID = 1L;");
        w.println();
        for (i3 = 0; i3 < numFields; ++i3) {
            w.println("\t/** Field " + i3 + " of the tuple. */");
            w.println("\tpublic T" + i3 + " f" + i3 + ';');
        }
        w.println();
        String paramList = "(";
        for (i2 = 0; i2 < numFields; ++i2) {
            if (i2 > 0) {
                paramList = paramList + ", ";
            }
            paramList = paramList + GEN_TYPE_PREFIX + i2 + " " + SETTER_ARG_NAME + i2;
        }
        paramList = paramList + ")";
        w.println("\t/**");
        w.println("\t * Creates a new tuple where all fields are null.");
        w.println("\t */");
        w.println("\tpublic " + className + "() {}");
        w.println();
        w.println("\t/**");
        w.println("\t * Creates a new tuple and assigns the given values to the tuple's fields.");
        w.println("\t *");
        for (i2 = 0; i2 < numFields; ++i2) {
            w.println("\t * @param f" + i2 + " The value for field " + i2);
        }
        w.println("\t */");
        w.println("\tpublic " + className + paramList + " {");
        for (i2 = 0; i2 < numFields; ++i2) {
            w.println("\t\tthis.f" + i2 + " = " + SETTER_ARG_NAME + i2 + ';');
        }
        w.println("\t}");
        w.println();
        w.println("\t@Override");
        w.println("\tpublic int getArity() {");
        w.println("\t\treturn " + numFields + ";");
        w.println("\t}");
        w.println();
        w.println("\t@Override");
        w.println("\t@SuppressWarnings(\"unchecked\")");
        w.println("\tpublic <T> T getField(int pos) {");
        w.println("\t\tswitch(pos) {");
        for (i2 = 0; i2 < numFields; ++i2) {
            w.println("\t\t\tcase " + i2 + ": return (T) this.f" + i2 + ';');
        }
        w.println("\t\t\tdefault: throw new IndexOutOfBoundsException(String.valueOf(pos));");
        w.println("\t\t}");
        w.println("\t}");
        w.println();
        w.println("\t@Override");
        w.println("\t@SuppressWarnings(\"unchecked\")");
        w.println("\tpublic <T> void setField(T value, int pos) {");
        w.println("\t\tswitch(pos) {");
        for (i2 = 0; i2 < numFields; ++i2) {
            w.println("\t\t\tcase " + i2 + ':');
            w.println("\t\t\t\tthis.f" + i2 + " = (" + GEN_TYPE_PREFIX + i2 + ") value;");
            w.println("\t\t\t\tbreak;");
        }
        w.println("\t\t\tdefault: throw new IndexOutOfBoundsException(String.valueOf(pos));");
        w.println("\t\t}");
        w.println("\t}");
        w.println();
        w.println("\t/**");
        w.println("\t * Sets new values to all fields of the tuple.");
        w.println("\t *");
        for (i2 = 0; i2 < numFields; ++i2) {
            w.println("\t * @param f" + i2 + " The value for field " + i2);
        }
        w.println("\t */");
        w.println("\tpublic void setFields" + paramList + " {");
        for (i2 = 0; i2 < numFields; ++i2) {
            w.println("\t\tthis.f" + i2 + " = " + SETTER_ARG_NAME + i2 + ';');
        }
        w.println("\t}");
        w.println();
        if (numFields == 2) {
            w.println("\t/**");
            w.println("\t* Returns a shallow copy of the tuple with swapped values.");
            w.println("\t*");
            w.println("\t* @return shallow copy of the tuple with swapped values");
            w.println("\t*/");
            w.println("\tpublic Tuple2<T1, T0> swap() {");
            w.println("\t\treturn new Tuple2<T1, T0>(f1, f0);");
            w.println("\t}");
        }
        w.println();
        w.println("\t// -------------------------------------------------------------------------------------------------");
        w.println("\t// standard utilities");
        w.println("\t// -------------------------------------------------------------------------------------------------");
        w.println();
        w.println("\t/**");
        w.println("\t * Creates a string representation of the tuple in the form");
        w.print("\t * (f0");
        for (i2 = 1; i2 < numFields; ++i2) {
            w.print(", f" + i2);
        }
        w.println("),");
        w.println("\t * where the individual fields are the value returned by calling {@link Object#toString} on that field.");
        w.println("\t * @return The string representation of the tuple.");
        w.println("\t */");
        w.println("\t@Override");
        w.println("\tpublic String toString() {");
        w.println("\t\treturn \"(\" + StringUtils.arrayAwareToString(this.f0)");
        for (i2 = 1; i2 < numFields; ++i2) {
            w.println("\t\t\t+ \",\" + StringUtils.arrayAwareToString(this.f" + i2 + ")");
        }
        w.println("\t\t\t+ \")\";");
        w.println("\t}");
        w.println();
        w.println("\t/**");
        w.println("\t * Deep equality for tuples by calling equals() on the tuple members.");
        w.println("\t * @param o the object checked for equality");
        w.println("\t * @return true if this is equal to o.");
        w.println("\t */");
        w.println("\t@Override");
        w.println("\tpublic boolean equals(Object o) {");
        w.println("\t\tif (this == o) {");
        w.println("\t\t\treturn true;");
        w.println("\t\t}");
        w.println("\t\tif (!(o instanceof " + className + ")) {");
        w.println("\t\t\treturn false;");
        w.println("\t\t}");
        w.println("\t\t@SuppressWarnings(\"rawtypes\")");
        w.println("\t\t" + className + " tuple = (" + className + ") o;");
        for (i2 = 0; i2 < numFields; ++i2) {
            field = SETTER_ARG_NAME + i2;
            w.println("\t\tif (" + field + " != null ? !" + field + ".equals(tuple." + field + ") : tuple." + field + " != null) {");
            w.println("\t\t\treturn false;");
            w.println("\t\t}");
        }
        w.println("\t\treturn true;");
        w.println("\t}");
        w.println();
        w.println("\t@Override");
        w.println("\tpublic int hashCode() {");
        w.println("\t\tint result = f0 != null ? f0.hashCode() : 0;");
        for (i2 = 1; i2 < numFields; ++i2) {
            field = SETTER_ARG_NAME + i2;
            w.println("\t\tresult = 31 * result + (" + field + " != null ? " + field + ".hashCode() : 0);");
        }
        w.println("\t\treturn result;");
        w.println("\t}");
        String tupleTypes = "";
        for (i = 0; i < numFields; ++i) {
            tupleTypes = tupleTypes + GEN_TYPE_PREFIX + i;
            if (i >= numFields - 1) continue;
            tupleTypes = tupleTypes + ", ";
        }
        w.println();
        w.println("\t/**");
        w.println("\t* Shallow tuple copy.");
        w.println("\t* @return A new Tuple with the same fields as this.");
        w.println("\t*/");
        w.println("\t@Override");
        w.println("\t@SuppressWarnings(\"unchecked\")");
        w.println("\tpublic " + className + "<" + tupleTypes + "> copy() {");
        w.print("\t\treturn new " + className + "<>(this.f0");
        if (numFields > 1) {
            w.println(",");
        }
        for (i = 1; i < numFields; ++i) {
            String field2 = SETTER_ARG_NAME + i;
            w.print("\t\t\tthis." + field2);
            if (i >= numFields - 1) continue;
            w.println(",");
        }
        w.println(");");
        w.println("\t}");
        w.println();
        w.println("\t/**");
        w.println("\t * Creates a new tuple and assigns the given values to the tuple's fields.");
        w.println("\t * This is more convenient than using the constructor, because the compiler can");
        w.println("\t * infer the generic type arguments implicitly. For example:");
        w.println("\t * {@code Tuple3.of(n, x, s)}");
        w.println("\t * instead of");
        w.println("\t * {@code new Tuple3<Integer, Double, String>(n, x, s)}");
        w.println("\t */");
        w.println("\tpublic static <" + tupleTypes + "> " + className + "<" + tupleTypes + "> of" + paramList + " {");
        w.print("\t\treturn new " + className + "<>(" + SETTER_ARG_NAME + "0");
        if (numFields > 1) {
            w.println(",");
        }
        for (i = 1; i < numFields; ++i) {
            w.print("\t\t\tf" + i);
            if (i >= numFields - 1) continue;
            w.println(",");
        }
        w.println(");");
        w.println("\t}");
        w.println("}");
    }

    private static void createTupleBuilderClasses(File root) throws FileNotFoundException {
        File dir = TupleGenerator.getPackage(root, "org.apache.flink.api.java.tuple.builder");
        for (int i = 1; i <= 25; ++i) {
            File tupleFile = new File(dir, TUPLE_CLASSNAME + i + "Builder.java");
            PrintWriter writer = new PrintWriter(tupleFile);
            TupleGenerator.writeTupleBuilderClass(writer, i);
            writer.flush();
            writer.close();
        }
    }

    private static void printGenericsString(PrintWriter w, int numFields) {
        w.print("<");
        for (int i = 0; i < numFields; ++i) {
            if (i > 0) {
                w.print(", ");
            }
            w.print(GEN_TYPE_PREFIX + i);
        }
        w.print(">");
    }

    private static void writeTupleBuilderClass(PrintWriter w, int numFields) {
        int i;
        String className = TUPLE_CLASSNAME + numFields + "Builder";
        w.print(HEADER);
        w.println("package org.apache.flink.api.java.tuple.builder;");
        w.println();
        w.println("import org.apache.flink.annotation.Public;");
        w.println("import org.apache.flink.api.java.tuple.Tuple" + numFields + ";");
        w.println();
        w.println("import java.util.ArrayList;");
        w.println("import java.util.List;");
        w.println();
        w.println("/**");
        w.println(" * A builder class for {@link Tuple" + numFields + "}.");
        w.println(" *");
        for (i = 0; i < numFields; ++i) {
            w.println(" * @param <T" + i + "> The type of field " + i);
        }
        w.println(" */");
        w.println("@Public");
        w.print("public class " + className);
        TupleGenerator.printGenericsString(w, numFields);
        w.println(" {");
        w.println();
        w.print("\tprivate List<Tuple" + numFields);
        TupleGenerator.printGenericsString(w, numFields);
        w.println("> tuples = new ArrayList<>();");
        w.println();
        w.print("\tpublic " + className);
        TupleGenerator.printGenericsString(w, numFields);
        w.print(" add(");
        for (i = 0; i < numFields; ++i) {
            if (i > 0) {
                w.print(", ");
            }
            w.print(GEN_TYPE_PREFIX + i + " " + SETTER_ARG_NAME + i);
        }
        w.println("){");
        w.print("\t\ttuples.add(new Tuple" + numFields + "<>(");
        for (i = 0; i < numFields; ++i) {
            if (i > 0) {
                w.print(", ");
            }
            w.print(SETTER_ARG_NAME + i);
        }
        w.println("));");
        w.println("\t\treturn this;");
        w.println("\t}");
        w.println();
        w.println("\t@SuppressWarnings(\"unchecked\")");
        w.print("\tpublic Tuple" + numFields);
        TupleGenerator.printGenericsString(w, numFields);
        w.println("[] build(){");
        w.println("\t\treturn tuples.toArray(new Tuple" + numFields + "[tuples.size()]);");
        w.println("\t}");
        w.println("}");
    }
}

