/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.java.typeutils.runtime.CopyableValueSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.CopyableValue;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

class CopyableSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<SimpleCopyable, SimpleCopyable> {
    CopyableSerializerUpgradeTest() {
    }

    @Override
    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("copyable-value-serializer", flinkVersion, CopyableSerializerSetup.class, CopyableSerializerVerifier.class));
        return testSpecifications;
    }

    @Test
    void testSimpleCopyableEqualsImplementation() {
        SimpleCopyable a = new SimpleCopyable(123456L);
        Assertions.assertThat((Object)a).isEqualTo((Object)new SimpleCopyable(123456L));
    }

    public static final class CopyableSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<SimpleCopyable> {
        @Override
        public TypeSerializer<SimpleCopyable> createUpgradedSerializer() {
            return new CopyableValueSerializer(SimpleCopyable.class);
        }

        @Override
        public Matcher<SimpleCopyable> testDataMatcher() {
            return Matchers.is((Object)new SimpleCopyable(123456L));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<SimpleCopyable>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class CopyableSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<SimpleCopyable> {
        @Override
        public TypeSerializer<SimpleCopyable> createPriorSerializer() {
            return new CopyableValueSerializer(SimpleCopyable.class);
        }

        @Override
        public SimpleCopyable createTestData() {
            return new SimpleCopyable(123456L);
        }
    }

    public static final class SimpleCopyable
    implements CopyableValue<SimpleCopyable> {
        public static final long serialVersionUID = 1L;
        private long value;

        public SimpleCopyable() {
        }

        public SimpleCopyable(long value) {
            this.value = value;
        }

        public int getBinaryLength() {
            return 8;
        }

        public void copyTo(SimpleCopyable target) {
            target.value = this.value;
        }

        public SimpleCopyable copy() {
            return new SimpleCopyable(this.value);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            target.writeLong(source.readLong());
        }

        public void write(DataOutputView out) throws IOException {
            out.writeLong(this.value);
        }

        public void read(DataInputView in) throws IOException {
            this.value = in.readLong();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SimpleCopyable)) {
                return false;
            }
            SimpleCopyable other = (SimpleCopyable)obj;
            return this.value == other.value;
        }
    }
}

