/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class DataInputViewStreamTest
extends TestLogger {
    @Test
    public void testSkip() throws IOException {
        TestInputStream inputStream = new TestInputStream();
        try (TestDataInputView dataInputView = new TestDataInputView(inputStream);
             DataInputViewStream dataInputViewStream = new DataInputViewStream((DataInputView)dataInputView);){
            Assert.assertEquals((long)1L, (long)dataInputViewStream.skip(1L));
            Assert.assertEquals((long)1L, (long)inputStream.skipped);
            long bigNumberToSkip = 4294968318L;
            Assert.assertEquals((long)4294968318L, (long)dataInputViewStream.skip(4294968318L));
            Assert.assertEquals((long)4294968319L, (long)inputStream.skipped);
        }
    }

    private static class TestInputStream
    extends InputStream {
        long skipped = 0L;

        private TestInputStream() {
        }

        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public long skip(long n) {
            this.skipped += n;
            return n;
        }
    }

    private static class TestDataInputView
    extends DataInputStream
    implements DataInputView {
        TestDataInputView(InputStream in) {
            super(in);
        }

        public void skipBytesToRead(int numBytes) throws IOException {
            throw new UnsupportedOperationException("Not properly implemented.");
        }
    }
}

