/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.util.Arrays;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.ComparatorTestBase;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.runtime.PojoContainingTuple;
import org.assertj.core.api.Assertions;

class PojoSubclassComparatorTest
extends ComparatorTestBase<PojoContainingTuple> {
    TypeInformation<PojoContainingTuple> type = TypeExtractor.getForClass(PojoContainingTuple.class);
    PojoContainingTuple[] data = new PojoContainingTuple[]{new Subclass(1, 1L, 1L, 17L), new Subclass(2, 2L, 2L, 42L), new Subclass(8519, 85190L, 85190L, 117L), new Subclass(8520, 85191L, 85191L, 93L)};

    PojoSubclassComparatorTest() {
    }

    @Override
    protected TypeComparator<PojoContainingTuple> createComparator(boolean ascending) {
        Assertions.assertThat(this.type).isInstanceOf(CompositeType.class);
        CompositeType cType = (CompositeType)this.type;
        Keys.ExpressionKeys keys = new Keys.ExpressionKeys(new String[]{"theTuple.*"}, (TypeInformation)cType);
        boolean[] orders = new boolean[keys.getNumberOfKeyFields()];
        Arrays.fill(orders, ascending);
        return cType.createComparator(keys.computeLogicalKeyPositions(), orders, 0, new ExecutionConfig());
    }

    @Override
    protected TypeSerializer<PojoContainingTuple> createSerializer() {
        return this.type.createSerializer((SerializerConfig)new SerializerConfigImpl());
    }

    protected PojoContainingTuple[] getSortedTestData() {
        return this.data;
    }

    public static class Subclass
    extends PojoContainingTuple {
        public long additionalField;

        public Subclass() {
        }

        public Subclass(int i, long l1, long l2, long additionalField) {
            super(i, l1, l2);
            this.additionalField = additionalField;
        }
    }
}

