/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class KryoSerializerCompatibilityTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testMigrationStrategyWithDifferentKryoType() throws Exception {
        byte[] serializedConfig;
        KryoSerializer kryoSerializerForA = new KryoSerializer(TestClassA.class, (SerializerConfig)new SerializerConfigImpl());
        TypeSerializerSnapshot kryoSerializerConfigSnapshot = kryoSerializerForA.snapshotConfiguration();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), (TypeSerializerSnapshot)kryoSerializerConfigSnapshot);
            serializedConfig = out.toByteArray();
        }
        KryoSerializer kryoSerializerForB = new KryoSerializer(TestClassB.class, (SerializerConfig)new SerializerConfigImpl());
        try (ByteArrayInputStream in = new ByteArrayInputStream(serializedConfig);){
            kryoSerializerConfigSnapshot = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        TypeSerializerSchemaCompatibility compatResult = kryoSerializerForB.snapshotConfiguration().resolveSchemaCompatibility(kryoSerializerConfigSnapshot);
        Assert.assertTrue((boolean)compatResult.isIncompatible());
    }

    @Test
    public void testMigrationOfTypeWithAvroType() throws Exception {
        SerializerConfigImpl serializerConfigImpl = new SerializerConfigImpl();
        class FakeAvroClass {
            public List<Integer> array;

            FakeAvroClass(List<Integer> array) {
                this.array = array;
            }
        }
        KryoSerializer kryoSerializer = new KryoSerializer(FakeAvroClass.class, (SerializerConfig)serializerConfigImpl);
        try (FileInputStream f = new FileInputStream("src/test/resources/type-with-avro-serialized-using-kryo");
             DataInputViewStreamWrapper inputView = new DataInputViewStreamWrapper((InputStream)f);){
            this.thrown.expectMessage("Could not find required Avro dependency");
            kryoSerializer.deserialize((DataInputView)inputView);
        }
    }

    @Test
    public void testMigrationWithTypeDevoidOfAvroTypes() throws Exception {
        SerializerConfigImpl serializerConfigImpl = new SerializerConfigImpl();
        class FakeClass {
            public List<Integer> array;

            FakeClass(List<Integer> array) {
                this.array = array;
            }
        }
        KryoSerializer kryoSerializer = new KryoSerializer(FakeClass.class, (SerializerConfig)serializerConfigImpl);
        try (FileInputStream f = new FileInputStream("src/test/resources/type-without-avro-serialized-using-kryo");
             DataInputViewStreamWrapper inputView = new DataInputViewStreamWrapper((InputStream)f);){
            FakeClass myTestClass = (FakeClass)kryoSerializer.deserialize((DataInputView)inputView);
            Assert.assertThat((Object)myTestClass.array.get(0), (Matcher)CoreMatchers.is((Object)10));
            Assert.assertThat((Object)myTestClass.array.get(1), (Matcher)CoreMatchers.is((Object)20));
            Assert.assertThat((Object)myTestClass.array.get(2), (Matcher)CoreMatchers.is((Object)30));
        }
    }

    @Test
    public void testMigrationStrategyForDifferentRegistrationOrder() throws Exception {
        byte[] serializedConfig;
        SerializerConfigImpl serializerConfigImpl = new SerializerConfigImpl();
        serializerConfigImpl.registerKryoType(TestClassA.class);
        serializerConfigImpl.registerKryoType(TestClassB.class);
        KryoSerializer kryoSerializer = new KryoSerializer(TestClass.class, (SerializerConfig)serializerConfigImpl);
        int testClassId = kryoSerializer.getKryo().getRegistration(TestClass.class).getId();
        int testClassAId = kryoSerializer.getKryo().getRegistration(TestClassA.class).getId();
        int testClassBId = kryoSerializer.getKryo().getRegistration(TestClassB.class).getId();
        TypeSerializerSnapshot kryoSerializerConfigSnapshot = kryoSerializer.snapshotConfiguration();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), (TypeSerializerSnapshot)kryoSerializerConfigSnapshot);
            serializedConfig = out.toByteArray();
        }
        serializerConfigImpl = new SerializerConfigImpl();
        serializerConfigImpl.registerKryoType(TestClassB.class);
        serializerConfigImpl.registerKryoType(TestClassA.class);
        kryoSerializer = new KryoSerializer(TestClass.class, (SerializerConfig)serializerConfigImpl);
        var9_8 = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(serializedConfig);){
            kryoSerializerConfigSnapshot = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        TypeSerializerSchemaCompatibility compatResult = kryoSerializer.snapshotConfiguration().resolveSchemaCompatibility(kryoSerializerConfigSnapshot);
        Assert.assertTrue((boolean)compatResult.isCompatibleWithReconfiguredSerializer());
        kryoSerializer = (KryoSerializer)compatResult.getReconfiguredSerializer();
        Assert.assertEquals((long)testClassId, (long)kryoSerializer.getKryo().getRegistration(TestClass.class).getId());
        Assert.assertEquals((long)testClassAId, (long)kryoSerializer.getKryo().getRegistration(TestClassA.class).getId());
        Assert.assertEquals((long)testClassBId, (long)kryoSerializer.getKryo().getRegistration(TestClassB.class).getId());
    }

    private static class TestClassBSerializer
    extends Serializer {
        private TestClassBSerializer() {
        }

        public void write(Kryo kryo, Output output, Object o) {
            throw new UnsupportedOperationException();
        }

        public Object read(Kryo kryo, Input input, Class aClass) {
            throw new UnsupportedOperationException();
        }
    }

    private static class TestClassB {
        private TestClassB() {
        }
    }

    private static class TestClassA {
        private TestClassA() {
        }
    }

    private static class TestClass {
        private TestClass() {
        }
    }
}

