/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import java.util.Collections;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.util.TestLogger;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConfigurationParsingInvalidFormatsTest
extends TestLogger {
    @Parameterized.Parameter
    public ConfigOption<?> option;
    @Parameterized.Parameter(value=1)
    public String invalidString;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Parameterized.Parameters(name="option: {0}, invalidString: {1}")
    public static Object[][] getSpecs() {
        return new Object[][]{{ConfigOptions.key((String)"int").intType().defaultValue((Object)1), "ABC"}, {ConfigOptions.key((String)"long").longType().defaultValue((Object)1L), "ABC"}, {ConfigOptions.key((String)"float").floatType().defaultValue((Object)Float.valueOf(1.0f)), "ABC"}, {ConfigOptions.key((String)"double").doubleType().defaultValue((Object)1.0), "ABC"}, {ConfigOptions.key((String)"boolean").booleanType().defaultValue((Object)true), "ABC"}, {ConfigOptions.key((String)"memory").memoryType().defaultValue((Object)MemorySize.parse((String)"1kB")), "ABC"}, {ConfigOptions.key((String)"duration").durationType().defaultValue((Object)Duration.ofSeconds(1L)), "ABC"}, {ConfigOptions.key((String)"enum").enumType(TestEnum.class).defaultValue((Object)TestEnum.ENUM1), "ABC"}, {ConfigOptions.key((String)"map").mapType().defaultValue(Collections.emptyMap()), "ABC"}, {ConfigOptions.key((String)"list<int>").intType().asList().defaultValues((Object[])new Integer[]{1, 2}), "A;B;C"}, {ConfigOptions.key((String)"list<string>").stringType().asList().defaultValues((Object[])new String[]{"A"}), "'A;B;C"}};
    }

    @Test
    public void testInvalidStringParsingWithGetOptional() {
        Configuration configuration = new Configuration();
        configuration.setString(this.option.key(), this.invalidString);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(String.format("Could not parse value '%s' for key '%s'", this.invalidString, this.option.key()));
        configuration.getOptional(this.option);
    }

    @Test
    public void testInvalidStringParsingWithGet() {
        Configuration configuration = new Configuration();
        configuration.setString(this.option.key(), this.invalidString);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(String.format("Could not parse value '%s' for key '%s'", this.invalidString, this.option.key()));
        configuration.get(this.option);
    }

    private static enum TestEnum {
        ENUM1,
        ENUM2;

    }
}

