/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class MemorySizeTest {
    @Test
    public void testUnitConversion() {
        MemorySize zero = MemorySize.ZERO;
        Assert.assertEquals((long)0L, (long)zero.getBytes());
        Assert.assertEquals((long)0L, (long)zero.getKibiBytes());
        Assert.assertEquals((long)0L, (long)zero.getMebiBytes());
        Assert.assertEquals((long)0L, (long)zero.getGibiBytes());
        Assert.assertEquals((long)0L, (long)zero.getTebiBytes());
        MemorySize bytes = new MemorySize(955L);
        Assert.assertEquals((long)955L, (long)bytes.getBytes());
        Assert.assertEquals((long)0L, (long)bytes.getKibiBytes());
        Assert.assertEquals((long)0L, (long)bytes.getMebiBytes());
        Assert.assertEquals((long)0L, (long)bytes.getGibiBytes());
        Assert.assertEquals((long)0L, (long)bytes.getTebiBytes());
        MemorySize kilos = new MemorySize(18500L);
        Assert.assertEquals((long)18500L, (long)kilos.getBytes());
        Assert.assertEquals((long)18L, (long)kilos.getKibiBytes());
        Assert.assertEquals((long)0L, (long)kilos.getMebiBytes());
        Assert.assertEquals((long)0L, (long)kilos.getGibiBytes());
        Assert.assertEquals((long)0L, (long)kilos.getTebiBytes());
        MemorySize megas = new MemorySize(0xF00000L);
        Assert.assertEquals((long)0xF00000L, (long)megas.getBytes());
        Assert.assertEquals((long)15360L, (long)megas.getKibiBytes());
        Assert.assertEquals((long)15L, (long)megas.getMebiBytes());
        Assert.assertEquals((long)0L, (long)megas.getGibiBytes());
        Assert.assertEquals((long)0L, (long)megas.getTebiBytes());
        MemorySize teras = new MemorySize(0x2000000000AL);
        Assert.assertEquals((long)0x2000000000AL, (long)teras.getBytes());
        Assert.assertEquals((long)0x80000000L, (long)teras.getKibiBytes());
        Assert.assertEquals((long)0x200000L, (long)teras.getMebiBytes());
        Assert.assertEquals((long)2048L, (long)teras.getGibiBytes());
        Assert.assertEquals((long)2L, (long)teras.getTebiBytes());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalid() {
        new MemorySize(-1L);
    }

    @Test
    public void testStandardUtils() throws IOException {
        MemorySize size = new MemorySize(1234567890L);
        MemorySize cloned = (MemorySize)CommonTestUtils.createCopySerializable((Serializable)size);
        Assert.assertEquals((Object)size, (Object)cloned);
        Assert.assertEquals((long)size.hashCode(), (long)cloned.hashCode());
        Assert.assertEquals((Object)size.toString(), (Object)cloned.toString());
    }

    @Test
    public void testParseBytes() {
        Assert.assertEquals((long)1234L, (long)MemorySize.parseBytes((String)"1234"));
        Assert.assertEquals((long)1234L, (long)MemorySize.parseBytes((String)"1234b"));
        Assert.assertEquals((long)1234L, (long)MemorySize.parseBytes((String)"1234 b"));
        Assert.assertEquals((long)1234L, (long)MemorySize.parseBytes((String)"1234bytes"));
        Assert.assertEquals((long)1234L, (long)MemorySize.parseBytes((String)"1234 bytes"));
    }

    @Test
    public void testParseKibiBytes() {
        Assert.assertEquals((long)667766L, (long)MemorySize.parse((String)"667766k").getKibiBytes());
        Assert.assertEquals((long)667766L, (long)MemorySize.parse((String)"667766 k").getKibiBytes());
        Assert.assertEquals((long)667766L, (long)MemorySize.parse((String)"667766kb").getKibiBytes());
        Assert.assertEquals((long)667766L, (long)MemorySize.parse((String)"667766 kb").getKibiBytes());
        Assert.assertEquals((long)667766L, (long)MemorySize.parse((String)"667766kibibytes").getKibiBytes());
        Assert.assertEquals((long)667766L, (long)MemorySize.parse((String)"667766 kibibytes").getKibiBytes());
    }

    @Test
    public void testParseMebiBytes() {
        Assert.assertEquals((long)7657623L, (long)MemorySize.parse((String)"7657623m").getMebiBytes());
        Assert.assertEquals((long)7657623L, (long)MemorySize.parse((String)"7657623 m").getMebiBytes());
        Assert.assertEquals((long)7657623L, (long)MemorySize.parse((String)"7657623mb").getMebiBytes());
        Assert.assertEquals((long)7657623L, (long)MemorySize.parse((String)"7657623 mb").getMebiBytes());
        Assert.assertEquals((long)7657623L, (long)MemorySize.parse((String)"7657623mebibytes").getMebiBytes());
        Assert.assertEquals((long)7657623L, (long)MemorySize.parse((String)"7657623 mebibytes").getMebiBytes());
    }

    @Test
    public void testParseGibiBytes() {
        Assert.assertEquals((long)987654L, (long)MemorySize.parse((String)"987654g").getGibiBytes());
        Assert.assertEquals((long)987654L, (long)MemorySize.parse((String)"987654 g").getGibiBytes());
        Assert.assertEquals((long)987654L, (long)MemorySize.parse((String)"987654gb").getGibiBytes());
        Assert.assertEquals((long)987654L, (long)MemorySize.parse((String)"987654 gb").getGibiBytes());
        Assert.assertEquals((long)987654L, (long)MemorySize.parse((String)"987654gibibytes").getGibiBytes());
        Assert.assertEquals((long)987654L, (long)MemorySize.parse((String)"987654 gibibytes").getGibiBytes());
    }

    @Test
    public void testParseTebiBytes() {
        Assert.assertEquals((long)1234567L, (long)MemorySize.parse((String)"1234567t").getTebiBytes());
        Assert.assertEquals((long)1234567L, (long)MemorySize.parse((String)"1234567 t").getTebiBytes());
        Assert.assertEquals((long)1234567L, (long)MemorySize.parse((String)"1234567tb").getTebiBytes());
        Assert.assertEquals((long)1234567L, (long)MemorySize.parse((String)"1234567 tb").getTebiBytes());
        Assert.assertEquals((long)1234567L, (long)MemorySize.parse((String)"1234567tebibytes").getTebiBytes());
        Assert.assertEquals((long)1234567L, (long)MemorySize.parse((String)"1234567 tebibytes").getTebiBytes());
    }

    @Test
    public void testUpperCase() {
        Assert.assertEquals((long)1L, (long)MemorySize.parse((String)"1 B").getBytes());
        Assert.assertEquals((long)1L, (long)MemorySize.parse((String)"1 K").getKibiBytes());
        Assert.assertEquals((long)1L, (long)MemorySize.parse((String)"1 M").getMebiBytes());
        Assert.assertEquals((long)1L, (long)MemorySize.parse((String)"1 G").getGibiBytes());
        Assert.assertEquals((long)1L, (long)MemorySize.parse((String)"1 T").getTebiBytes());
    }

    @Test
    public void testTrimBeforeParse() {
        Assert.assertEquals((long)155L, (long)MemorySize.parseBytes((String)"      155      "));
        Assert.assertEquals((long)155L, (long)MemorySize.parseBytes((String)"      155      bytes   "));
    }

    @Test
    public void testParseInvalid() {
        try {
            MemorySize.parseBytes(null);
            Assert.fail((String)"exception expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            MemorySize.parseBytes((String)"");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            MemorySize.parseBytes((String)"     ");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            MemorySize.parseBytes((String)"foobar or fubar or foo bazz");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            MemorySize.parseBytes((String)"16 gjah");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            MemorySize.parseBytes((String)"16 16 17 18 bytes");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            MemorySize.parseBytes((String)"-100 bytes");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseNumberOverflow() {
        MemorySize.parseBytes((String)"100000000000000000000000000000000 bytes");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseNumberTimeUnitOverflow() {
        MemorySize.parseBytes((String)"100000000000000 tb");
    }

    @Test
    public void testParseWithDefaultUnit() {
        Assert.assertEquals((long)7L, (long)MemorySize.parse((String)"7", (MemorySize.MemoryUnit)MemorySize.MemoryUnit.MEGA_BYTES).getMebiBytes());
        Assert.assertNotEquals((Object)7, (Object)MemorySize.parse((String)"7340032", (MemorySize.MemoryUnit)MemorySize.MemoryUnit.MEGA_BYTES));
        Assert.assertEquals((long)7L, (long)MemorySize.parse((String)"7m", (MemorySize.MemoryUnit)MemorySize.MemoryUnit.MEGA_BYTES).getMebiBytes());
        Assert.assertEquals((long)7168L, (long)MemorySize.parse((String)"7", (MemorySize.MemoryUnit)MemorySize.MemoryUnit.MEGA_BYTES).getKibiBytes());
        Assert.assertEquals((long)7168L, (long)MemorySize.parse((String)"7m", (MemorySize.MemoryUnit)MemorySize.MemoryUnit.MEGA_BYTES).getKibiBytes());
        Assert.assertEquals((long)7L, (long)MemorySize.parse((String)"7 m", (MemorySize.MemoryUnit)MemorySize.MemoryUnit.MEGA_BYTES).getMebiBytes());
        Assert.assertEquals((long)7L, (long)MemorySize.parse((String)"7mb", (MemorySize.MemoryUnit)MemorySize.MemoryUnit.MEGA_BYTES).getMebiBytes());
        Assert.assertEquals((long)7L, (long)MemorySize.parse((String)"7 mb", (MemorySize.MemoryUnit)MemorySize.MemoryUnit.MEGA_BYTES).getMebiBytes());
        Assert.assertEquals((long)7L, (long)MemorySize.parse((String)"7mebibytes", (MemorySize.MemoryUnit)MemorySize.MemoryUnit.MEGA_BYTES).getMebiBytes());
        Assert.assertEquals((long)7L, (long)MemorySize.parse((String)"7 mebibytes", (MemorySize.MemoryUnit)MemorySize.MemoryUnit.MEGA_BYTES).getMebiBytes());
    }

    @Test
    public void testDivideByLong() {
        MemorySize memory = new MemorySize(100L);
        Assert.assertThat((Object)memory.divide(23L), (Matcher)CoreMatchers.is((Object)new MemorySize(4L)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDivideByNegativeLong() {
        MemorySize memory = new MemorySize(100L);
        memory.divide(-23L);
    }

    @Test
    public void testToHumanReadableString() {
        Assert.assertThat((Object)new MemorySize(0L).toHumanReadableString(), (Matcher)CoreMatchers.is((Object)"0 bytes"));
        Assert.assertThat((Object)new MemorySize(1L).toHumanReadableString(), (Matcher)CoreMatchers.is((Object)"1 bytes"));
        Assert.assertThat((Object)new MemorySize(1024L).toHumanReadableString(), (Matcher)CoreMatchers.is((Object)"1024 bytes"));
        Assert.assertThat((Object)new MemorySize(1025L).toHumanReadableString(), (Matcher)CoreMatchers.is((Object)"1.001kb (1025 bytes)"));
        Assert.assertThat((Object)new MemorySize(1536L).toHumanReadableString(), (Matcher)CoreMatchers.is((Object)"1.500kb (1536 bytes)"));
        Assert.assertThat((Object)new MemorySize(1000000L).toHumanReadableString(), (Matcher)CoreMatchers.is((Object)"976.563kb (1000000 bytes)"));
        Assert.assertThat((Object)new MemorySize(1000000000L).toHumanReadableString(), (Matcher)CoreMatchers.is((Object)"953.674mb (1000000000 bytes)"));
        Assert.assertThat((Object)new MemorySize(1000000000000L).toHumanReadableString(), (Matcher)CoreMatchers.is((Object)"931.323gb (1000000000000 bytes)"));
        Assert.assertThat((Object)new MemorySize(1000000000000000L).toHumanReadableString(), (Matcher)CoreMatchers.is((Object)"909.495tb (1000000000000000 bytes)"));
    }
}

