/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.configuration.StructuredOptionsSplitter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StructuredOptionsSplitterEscapeTest {
    @Parameterized.Parameter
    public TestSpec testSpec;

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestSpec> getEncodeSpecs() {
        return Arrays.asList(TestSpec.encode("A,B,C,D", ";").expect("A,B,C,D"), TestSpec.encode("A;BCD", ";").expect("'A;BCD'"), TestSpec.encode("A'B'C'D", ";").expect("'A''B''C''D'"), TestSpec.encode("AB\"C\"D", ";").expect("'AB\"C\"D'"), TestSpec.encode("AB'\"D:B", ";").expect("'AB''\"D:B'"), TestSpec.encode("A,B,C,D", ",").expect("'A,B,C,D'"), TestSpec.encode("A;BCD", ",").expect("A;BCD"), TestSpec.encode("AB\"C\"D", ",").expect("'AB\"C\"D'"), TestSpec.encode("AB'\"D:B", ",").expect("'AB''\"D:B'"), TestSpec.encode("A;B;C;D", ",", ":").expect("A;B;C;D"), TestSpec.encode("A;B;C:D", ",", ":").expect("'A;B;C:D'"));
    }

    @Test
    public void testEscapeWithSingleQuote() {
        String encoded = StructuredOptionsSplitter.escapeWithSingleQuote((String)this.testSpec.getString(), (String[])this.testSpec.getEscapeChars());
        Assert.assertEquals((Object)this.testSpec.getEncodedString(), (Object)encoded);
    }

    private static class TestSpec {
        private final String string;
        private final String[] escapeChars;
        private String encodedString;

        private TestSpec(String string, String ... escapeChars) {
            this.string = string;
            this.escapeChars = escapeChars;
        }

        public static TestSpec encode(String string, String ... escapeChars) {
            return new TestSpec(string, escapeChars);
        }

        public TestSpec expect(String string) {
            this.encodedString = string;
            return this;
        }

        public String getString() {
            return this.string;
        }

        public String getEncodedString() {
            return this.encodedString;
        }

        public String[] getEscapeChars() {
            return this.escapeChars;
        }
    }
}

