/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ByteArrayInputStreamWithPosTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final byte[] data = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private final ByteArrayInputStreamWithPos stream = new ByteArrayInputStreamWithPos(this.data);

    @Test
    public void testGetWithNullArray() {
        this.thrown.expect(NullPointerException.class);
        this.stream.read(null, 0, 1);
    }

    @Test
    public void testGetWithNegativeLength() {
        int read = this.stream.read(new byte[0], 0, -1);
        Assert.assertEquals((long)0L, (long)read);
    }

    @Test
    public void testGetWithTargetArrayOverflow() {
        this.thrown.expect(IndexOutOfBoundsException.class);
        this.stream.read(new byte[0], 0, 2);
    }

    @Test
    public void testGetWithEOF() {
        ByteArrayInputStreamWithPosTest.drainStream(this.stream);
        int read = this.stream.read(new byte[1], 0, 1);
        Assert.assertEquals((long)-1L, (long)read);
    }

    @Test
    public void testGetMoreThanAvailable() {
        int read = this.stream.read(new byte[20], 0, 20);
        Assert.assertEquals((long)10L, (long)read);
        Assert.assertEquals((long)-1L, (long)this.stream.read());
    }

    @Test
    public void testSetPosition() throws Exception {
        Assert.assertEquals((long)this.data.length, (long)this.stream.available());
        Assert.assertEquals((long)48L, (long)this.stream.read());
        this.stream.setPosition(1);
        Assert.assertEquals((long)(this.data.length - 1), (long)this.stream.available());
        Assert.assertEquals((long)49L, (long)this.stream.read());
        this.stream.setPosition(3);
        Assert.assertEquals((long)(this.data.length - 3), (long)this.stream.available());
        Assert.assertEquals((long)51L, (long)this.stream.read());
        this.stream.setPosition(this.data.length);
        Assert.assertEquals((long)0L, (long)this.stream.available());
        Assert.assertEquals((long)-1L, (long)this.stream.read());
    }

    @Test
    public void testSetTooLargePosition() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Position out of bounds.");
        this.stream.setPosition(this.data.length + 1);
    }

    @Test
    public void testSetNegativePosition() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Position out of bounds.");
        this.stream.setPosition(-1);
    }

    @Test
    public void testSetBuffer() {
        ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos();
        Assert.assertEquals((long)-1L, (long)in.read());
        byte[] testData = new byte[]{66, 67, 68, 69};
        int off = 1;
        int len = 2;
        in.setBuffer(testData, off, len);
        for (int i = 0; i < len; ++i) {
            Assert.assertEquals((long)testData[i + off], (long)in.read());
        }
        Assert.assertEquals((long)-1L, (long)in.read());
    }

    private static int drainStream(ByteArrayInputStreamWithPos stream) {
        int skipped = 0;
        while (stream.read() != -1) {
            ++skipped;
        }
        return skipped;
    }
}

