/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.util.ArrayList;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.CharValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.JavaToValueConverter;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.junit.Assert;
import org.junit.Test;

public class JavaToValueConverterTest {
    @Test
    public void testJavaToValueConversion() {
        try {
            Assert.assertNull((Object)JavaToValueConverter.convertBoxedJavaType(null));
            Assert.assertEquals((Object)new StringValue((CharSequence)"123Test"), (Object)JavaToValueConverter.convertBoxedJavaType((Object)"123Test"));
            Assert.assertEquals((Object)new ByteValue(44), (Object)JavaToValueConverter.convertBoxedJavaType((Object)44));
            Assert.assertEquals((Object)new ShortValue(10000), (Object)JavaToValueConverter.convertBoxedJavaType((Object)10000));
            Assert.assertEquals((Object)new IntValue(3567564), (Object)JavaToValueConverter.convertBoxedJavaType((Object)3567564));
            Assert.assertEquals((Object)new LongValue(767692734L), (Object)JavaToValueConverter.convertBoxedJavaType((Object)767692734L));
            Assert.assertEquals((Object)new FloatValue(17.5f), (Object)JavaToValueConverter.convertBoxedJavaType((Object)Float.valueOf(17.5f)));
            Assert.assertEquals((Object)new DoubleValue(3.1415926), (Object)JavaToValueConverter.convertBoxedJavaType((Object)3.1415926));
            Assert.assertEquals((Object)new BooleanValue(true), (Object)JavaToValueConverter.convertBoxedJavaType((Object)true));
            Assert.assertEquals((Object)new CharValue('@'), (Object)JavaToValueConverter.convertBoxedJavaType((Object)Character.valueOf('@')));
            try {
                JavaToValueConverter.convertBoxedJavaType(new ArrayList());
                Assert.fail((String)"Accepted invalid type.");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testValueToJavaConversion() {
        try {
            Assert.assertNull((Object)JavaToValueConverter.convertValueType(null));
            Assert.assertEquals((Object)"123Test", (Object)JavaToValueConverter.convertValueType((Value)new StringValue((CharSequence)"123Test")));
            Assert.assertEquals((Object)44, (Object)JavaToValueConverter.convertValueType((Value)new ByteValue(44)));
            Assert.assertEquals((Object)10000, (Object)JavaToValueConverter.convertValueType((Value)new ShortValue(10000)));
            Assert.assertEquals((Object)3567564, (Object)JavaToValueConverter.convertValueType((Value)new IntValue(3567564)));
            Assert.assertEquals((Object)767692734L, (Object)JavaToValueConverter.convertValueType((Value)new LongValue(767692734L)));
            Assert.assertEquals((Object)Float.valueOf(17.5f), (Object)JavaToValueConverter.convertValueType((Value)new FloatValue(17.5f)));
            Assert.assertEquals((Object)3.1415926, (Object)JavaToValueConverter.convertValueType((Value)new DoubleValue(3.1415926)));
            Assert.assertEquals((Object)true, (Object)JavaToValueConverter.convertValueType((Value)new BooleanValue(true)));
            Assert.assertEquals((Object)Character.valueOf('@'), (Object)JavaToValueConverter.convertValueType((Value)new CharValue('@')));
            try {
                JavaToValueConverter.convertValueType((Value)new MyValue());
                Assert.fail((String)"Accepted invalid type.");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static final class MyValue
    implements Value {
        private static final long serialVersionUID = 1L;

        private MyValue() {
        }

        public void write(DataOutputView out) {
        }

        public void read(DataInputView in) {
        }
    }
}

