/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.flink.util.FlinkUserCodeClassLoader;
import org.apache.flink.util.MutableURLClassLoader;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FlinkUserCodeClassLoaderTest
extends TestLogger {
    @Test
    public void testExceptionHandling() {
        RuntimeException expectedException = new RuntimeException("Expected exception");
        AtomicReference handledException = new AtomicReference();
        try (ThrowingURLClassLoader classLoaderWithErrorHandler = new ThrowingURLClassLoader(handledException::set, expectedException);){
            classLoaderWithErrorHandler.loadClass("dummy.class");
            Assert.fail((String)"The expected exception is not thrown");
        }
        catch (Throwable t) {
            Assert.assertThat(handledException.get(), (Matcher)CoreMatchers.is((Object)expectedException));
            Assert.assertThat((Object)t, (Matcher)CoreMatchers.is((Object)expectedException));
        }
    }

    private static class ThrowingURLClassLoader
    extends FlinkUserCodeClassLoader {
        private final RuntimeException expectedException;

        ThrowingURLClassLoader(Consumer<Throwable> classLoadingExceptionHandler, RuntimeException expectedException) {
            super(new URL[0], null, classLoadingExceptionHandler);
            this.expectedException = expectedException;
        }

        protected Class<?> loadClassWithoutExceptionHandling(String name, boolean resolve) {
            throw this.expectedException;
        }

        public MutableURLClassLoader copy() {
            return new ThrowingURLClassLoader(this.classLoadingExceptionHandler, this.expectedException);
        }
    }
}

