/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.DoubleMaximum;
import org.junit.Assert;
import org.junit.Test;

public class DoubleMaximumTest {
    @Test
    public void testGet() {
        DoubleMaximum max = new DoubleMaximum();
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)max.getLocalValue(), (double)0.0);
    }

    @Test
    public void testResetLocal() {
        DoubleMaximum max = new DoubleMaximum();
        double value = 13.57902468;
        max.add(value);
        Assert.assertEquals((double)value, (double)max.getLocalValue(), (double)0.0);
        max.resetLocal();
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)max.getLocalValue(), (double)0.0);
    }

    @Test
    public void testAdd() {
        DoubleMaximum max = new DoubleMaximum();
        max.add(1234.5768);
        max.add(9876.5432);
        max.add(-987.6543);
        max.add(-123.4567);
        Assert.assertEquals((double)9876.5432, (double)max.getLocalValue(), (double)0.0);
    }

    @Test
    public void testMerge() {
        DoubleMaximum max1 = new DoubleMaximum();
        max1.add(1234.5768);
        DoubleMaximum max2 = new DoubleMaximum();
        max2.add(5678.9012);
        max2.merge((Accumulator)max1);
        Assert.assertEquals((double)5678.9012, (double)max2.getLocalValue(), (double)0.0);
        max1.merge((Accumulator)max2);
        Assert.assertEquals((double)5678.9012, (double)max1.getLocalValue(), (double)0.0);
    }

    @Test
    public void testClone() {
        DoubleMaximum max = new DoubleMaximum();
        double value = 3.14159265359;
        max.add(value);
        DoubleMaximum clone = max.clone();
        Assert.assertEquals((double)value, (double)clone.getLocalValue(), (double)0.0);
    }
}

