/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.io.FilePathFilter;
import org.apache.flink.core.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DefaultFilterTest {
    private final boolean shouldFilter;
    private final String filePath;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"file.txt", false}, {".file.txt", true}, {"dir/.file.txt", true}, {".dir/file.txt", false}, {"_file.txt", true}, {"dir/_file.txt", true}, {"_dir/file.txt", false}, {"_COPYING_", true}, {"dir/_COPYING_", true}, {"_COPYING_/file.txt", false});
    }

    public DefaultFilterTest(String filePath, boolean shouldFilter) {
        this.filePath = filePath;
        this.shouldFilter = shouldFilter;
    }

    @Test
    public void test() {
        FilePathFilter defaultFilter = FilePathFilter.createDefaultFilter();
        Path path = new Path(this.filePath);
        Assert.assertEquals((String)String.format("File: %s", this.filePath), (Object)this.shouldFilter, (Object)defaultFilter.filterPath(path));
    }
}

