/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.File;
import java.io.IOException;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.IntValue;
import org.junit.Assert;
import org.junit.Test;

public class FileOutputFormatTest {
    @Test
    public void testCreateNonParallelLocalFS() throws IOException {
        File tmpOutPath = File.createTempFile("fileOutputFormatTest", "Test1");
        File tmpOutFile = new File(tmpOutPath.getAbsolutePath() + "/1");
        String tmpFilePath = tmpOutPath.toURI().toString();
        DummyFileOutputFormat dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        tmpOutPath.delete();
        Assert.assertTrue((String)"Directory could not be created.", (boolean)tmpOutPath.mkdir());
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isFile() ? 1 : 0) != 0);
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath + "/"));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isFile() ? 1 : 0) != 0);
        tmpOutPath.delete();
        tmpOutPath.createNewFile();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        tmpOutPath.delete();
        Assert.assertTrue((String)"Directory could not be created.", (boolean)tmpOutPath.mkdir());
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        new File(tmpOutPath.getAbsoluteFile() + "/1").delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.testFileName = true;
        Configuration c = new Configuration();
        dfof.configure(c);
        try {
            dfof.open(0, 1);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        File customOutFile = new File(tmpOutPath.getAbsolutePath() + "/fancy-1-0.avro");
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((customOutFile.exists() && customOutFile.isFile() ? 1 : 0) != 0);
        customOutFile.delete();
        customOutFile = new File(tmpOutPath.getAbsolutePath() + "/1");
        customOutFile.createNewFile();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        new File(tmpOutPath.getAbsoluteFile() + "/1").delete();
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        new File(tmpOutPath.getAbsoluteFile() + "/1").delete();
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath + '/'));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        new File(tmpOutPath.getAbsoluteFile() + "/1").delete();
        tmpOutPath.delete();
    }

    @Test
    public void testCreateParallelLocalFS() throws IOException {
        File tmpOutPath = null;
        File tmpOutFile = null;
        tmpOutPath = File.createTempFile("fileOutputFormatTest", "Test1");
        tmpOutFile = new File(tmpOutPath.getAbsolutePath() + "/1");
        String tmpFilePath = tmpOutPath.toURI().toString();
        DummyFileOutputFormat dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 2);
            dfof.close();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        tmpOutPath.delete();
        Assert.assertTrue((String)"Directory could not be created.", (boolean)tmpOutPath.mkdir());
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 2);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        tmpOutFile.delete();
        tmpOutPath.delete();
        tmpOutPath.mkdir();
        tmpOutFile.createNewFile();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 2);
            dfof.close();
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        tmpOutFile.delete();
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 2);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        tmpOutFile.delete();
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath + "/"));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 2);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        tmpOutFile.delete();
        tmpOutPath.delete();
    }

    @Test
    public void testOverwriteNonParallelLocalFS() throws IOException {
        File tmpOutPath = null;
        File tmpOutFile = null;
        tmpOutPath = File.createTempFile("fileOutputFormatTest", "Test1");
        tmpOutFile = new File(tmpOutPath.getAbsolutePath() + "/1");
        String tmpFilePath = tmpOutPath.toURI().toString();
        DummyFileOutputFormat dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isFile() ? 1 : 0) != 0);
        tmpOutPath.delete();
        Assert.assertTrue((String)"Directory could not be created.", (boolean)tmpOutPath.mkdir());
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isFile() ? 1 : 0) != 0);
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isFile() ? 1 : 0) != 0);
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath + "/"));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isFile() ? 1 : 0) != 0);
        tmpOutPath.delete();
        tmpOutPath.createNewFile();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        tmpOutFile.delete();
        tmpOutPath.delete();
        Assert.assertTrue((String)"Directory could not be created.", (boolean)tmpOutPath.mkdir());
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        tmpOutPath.delete();
        tmpOutFile.delete();
        tmpOutPath.mkdir();
        tmpOutFile.createNewFile();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        tmpOutPath.delete();
        tmpOutFile.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        tmpOutFile.delete();
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath + "/"));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 1);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        tmpOutFile.delete();
        tmpOutPath.delete();
    }

    @Test
    public void testOverwriteParallelLocalFS() throws IOException {
        File tmpOutPath = null;
        File tmpOutFile = null;
        tmpOutPath = File.createTempFile("fileOutputFormatTest", "Test1");
        tmpOutFile = new File(tmpOutPath.getAbsolutePath() + "/1");
        String tmpFilePath = tmpOutPath.toURI().toString();
        DummyFileOutputFormat dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 2);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        tmpOutFile.delete();
        tmpOutPath.delete();
        Assert.assertTrue((String)"Directory could not be created.", (boolean)tmpOutPath.mkdir());
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 2);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        tmpOutFile.delete();
        tmpOutPath.delete();
        tmpOutPath.mkdir();
        tmpOutFile.createNewFile();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 2);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        new File(tmpOutPath.getAbsoluteFile() + "/1").delete();
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 2);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        tmpOutFile.delete();
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath + "/"));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        try {
            dfof.open(0, 2);
            dfof.close();
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((tmpOutPath.exists() && tmpOutPath.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((tmpOutFile.exists() && tmpOutFile.isFile() ? 1 : 0) != 0);
        tmpOutFile.delete();
        tmpOutPath.delete();
    }

    public static class DummyFileOutputFormat
    extends FileOutputFormat<IntValue> {
        private static final long serialVersionUID = 1L;
        public boolean testFileName = false;

        public void writeRecord(IntValue record) throws IOException {
        }

        protected String getDirectoryFileName(int taskNumber) {
            if (this.testFileName) {
                return "fancy-" + (taskNumber + 1) + "-" + taskNumber + ".avro";
            }
            return super.getDirectoryFileName(taskNumber);
        }
    }
}

