/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.util;

import java.io.IOException;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.NonParallelInput;
import org.apache.flink.api.common.operators.util.TestIOData;

public class TestRichInputFormat
extends GenericInputFormat<String>
implements NonParallelInput {
    private static final long serialVersionUID = 1L;
    private static final int NUM = 5;
    private static final String[] NAMES = TestIOData.NAMES;
    private int count = 0;
    private boolean openCalled = false;
    private boolean closeCalled = false;

    public boolean reachedEnd() throws IOException {
        return this.count >= 5;
    }

    public String nextRecord(String reuse) throws IOException {
        ++this.count;
        return NAMES[this.count - 1] + this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask() + "" + this.getRuntimeContext().getTaskInfo().getNumberOfParallelSubtasks();
    }

    public void reset() {
        this.count = 0;
        this.openCalled = false;
        this.closeCalled = false;
    }

    public void openInputFormat() {
        this.openCalled = true;
    }

    public void closeInputFormat() {
        this.closeCalled = true;
    }

    public boolean hasBeenOpened() {
        return this.openCalled;
    }

    public boolean hasBeenClosed() {
        return this.closeCalled;
    }
}

