/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInfoFactory;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SerializerConfigImplTest {
    SerializerConfigImplTest() {
    }

    @Test
    void testReadingDefaultConfig() {
        SerializerConfigImpl config = new SerializerConfigImpl();
        Configuration configuration = new Configuration();
        config.configure((ReadableConfig)configuration, SerializerConfigImplTest.class.getClassLoader());
        Assertions.assertThat((Object)config).isEqualTo((Object)new SerializerConfigImpl());
    }

    @Test
    void testDoubleTypeRegistration() {
        SerializerConfigImpl config = new SerializerConfigImpl();
        List<Class> types = Arrays.asList(Double.class, Integer.class, Double.class);
        List<Class> expectedTypes = Arrays.asList(Double.class, Integer.class);
        for (Class tpe : types) {
            config.registerKryoType(tpe);
        }
        int counter = 0;
        for (Class tpe : config.getRegisteredKryoTypes()) {
            Assertions.assertThat((Class)tpe).isEqualTo((Object)expectedTypes.get(counter++));
        }
        Assertions.assertThat((int)expectedTypes.size()).isEqualTo(counter);
    }

    @Test
    void testLoadingRegisteredKryoTypesFromConfiguration() {
        SerializerConfigImpl configFromSetters = new SerializerConfigImpl();
        configFromSetters.registerKryoType(SerializerConfigImplTest.class);
        configFromSetters.registerKryoType(TestSerializer1.class);
        SerializerConfigImpl configFromConfiguration = new SerializerConfigImpl();
        Configuration configuration = new Configuration();
        configuration.setString("pipeline.registered-kryo-types", "org.apache.flink.api.common.serialization.SerializerConfigImplTest;org.apache.flink.api.common.serialization.SerializerConfigImplTest$TestSerializer1");
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Collection)configFromConfiguration.getRegisteredKryoTypes()).isEqualTo((Object)configFromSetters.getRegisteredKryoTypes());
    }

    @Test
    void testLoadingRegisteredPojoTypesFromConfiguration() {
        SerializerConfigImpl configFromSetters = new SerializerConfigImpl();
        configFromSetters.registerPojoType(SerializerConfigImplTest.class);
        configFromSetters.registerPojoType(TestSerializer1.class);
        SerializerConfigImpl configFromConfiguration = new SerializerConfigImpl();
        Configuration configuration = new Configuration();
        configuration.setString("pipeline.registered-pojo-types", "org.apache.flink.api.common.serialization.SerializerConfigImplTest;org.apache.flink.api.common.serialization.SerializerConfigImplTest$TestSerializer1");
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Collection)configFromConfiguration.getRegisteredPojoTypes()).isEqualTo((Object)configFromSetters.getRegisteredPojoTypes());
    }

    @Test
    void testLoadingDefaultKryoSerializersFromConfiguration() {
        SerializerConfigImpl configFromSetters = new SerializerConfigImpl();
        configFromSetters.addDefaultKryoSerializer(SerializerConfigImplTest.class, TestSerializer1.class);
        configFromSetters.addDefaultKryoSerializer(TestSerializer1.class, TestSerializer2.class);
        SerializerConfigImpl configFromConfiguration = new SerializerConfigImpl();
        Configuration configuration = new Configuration();
        configuration.setString("pipeline.default-kryo-serializers", "class:org.apache.flink.api.common.serialization.SerializerConfigImplTest,serializer:org.apache.flink.api.common.serialization.SerializerConfigImplTest$TestSerializer1;class:org.apache.flink.api.common.serialization.SerializerConfigImplTest$TestSerializer1,serializer:org.apache.flink.api.common.serialization.SerializerConfigImplTest$TestSerializer2");
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Map)configFromConfiguration.getDefaultKryoSerializers()).isEqualTo((Object)configFromSetters.getDefaultKryoSerializers());
    }

    @Test
    void testNotOverridingRegisteredKryoTypesWithDefaultsFromConfiguration() {
        SerializerConfigImpl config = new SerializerConfigImpl();
        config.registerKryoType(SerializerConfigImplTest.class);
        config.registerKryoType(TestSerializer1.class);
        Configuration configuration = new Configuration();
        config.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        LinkedHashSet<Class> set = new LinkedHashSet<Class>();
        set.add(SerializerConfigImplTest.class);
        set.add(TestSerializer1.class);
        Assertions.assertThat((Collection)config.getRegisteredKryoTypes()).isEqualTo(set);
    }

    @Test
    void testNotOverridingRegisteredPojoTypesWithDefaultsFromConfiguration() {
        SerializerConfigImpl config = new SerializerConfigImpl();
        config.registerPojoType(SerializerConfigImplTest.class);
        config.registerPojoType(TestSerializer1.class);
        Configuration configuration = new Configuration();
        config.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        LinkedHashSet<Class> set = new LinkedHashSet<Class>();
        set.add(SerializerConfigImplTest.class);
        set.add(TestSerializer1.class);
        Assertions.assertThat((Collection)config.getRegisteredPojoTypes()).isEqualTo(set);
    }

    @Test
    void testNotOverridingDefaultKryoSerializersFromConfiguration() {
        SerializerConfigImpl config = new SerializerConfigImpl();
        config.addDefaultKryoSerializer(SerializerConfigImplTest.class, TestSerializer1.class);
        config.addDefaultKryoSerializer(TestSerializer1.class, TestSerializer2.class);
        Configuration configuration = new Configuration();
        config.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        LinkedHashMap<Class, Class> serializers = new LinkedHashMap<Class, Class>();
        serializers.put(SerializerConfigImplTest.class, TestSerializer1.class);
        serializers.put(TestSerializer1.class, TestSerializer2.class);
        Assertions.assertThat((Map)config.getDefaultKryoSerializerClasses()).isEqualTo(serializers);
    }

    @Test
    void testLoadingPojoTypesFromSerializationConfig() {
        String serializationConfigStr = "[org.apache.flink.api.common.serialization.SerializerConfigImplTest: {type: pojo}, org.apache.flink.api.common.serialization.SerializerConfigImplTest$TestSerializer1: {type: pojo}, org.apache.flink.api.common.serialization.SerializerConfigImplTest$TestSerializer2: {type: pojo}]";
        SerializerConfig serializerConfig = this.getConfiguredSerializerConfig(serializationConfigStr);
        Assertions.assertThat((Collection)serializerConfig.getRegisteredPojoTypes()).containsExactly((Object[])new Class[]{SerializerConfigImplTest.class, TestSerializer1.class, TestSerializer2.class});
    }

    @Test
    void testLoadingKryoTypesFromSerializationConfig() {
        String serializationConfigStr = "{org.apache.flink.api.common.serialization.SerializerConfigImplTest: {type: kryo}, org.apache.flink.api.common.serialization.SerializerConfigImplTest$TestSerializer1: {type: kryo, kryo-type: default, class: org.apache.flink.api.common.serialization.SerializerConfigImplTest$TestSerializer2}, org.apache.flink.api.common.serialization.SerializerConfigImplTest$TestSerializer2: {type: kryo, kryo-type: registered, class: org.apache.flink.api.common.serialization.SerializerConfigImplTest$TestSerializer3}}";
        SerializerConfig serializerConfig = this.getConfiguredSerializerConfig(serializationConfigStr);
        Assertions.assertThat((Collection)serializerConfig.getRegisteredKryoTypes()).containsExactly((Object[])new Class[]{SerializerConfigImplTest.class});
        Assertions.assertThat((Map)serializerConfig.getDefaultKryoSerializerClasses()).containsExactly(new Map.Entry[]{new AbstractMap.SimpleEntry<Class<TestSerializer1>, Class<TestSerializer2>>(TestSerializer1.class, TestSerializer2.class)});
        Assertions.assertThat((Map)serializerConfig.getRegisteredTypesWithKryoSerializerClasses()).containsExactly(new Map.Entry[]{new AbstractMap.SimpleEntry<Class<TestSerializer2>, Class<TestSerializer3>>(TestSerializer2.class, TestSerializer3.class)});
    }

    @Test
    void testLoadingTypeInfoFactoriesFromSerializationConfig() {
        String serializationConfigStr = "{org.apache.flink.api.common.serialization.SerializerConfigImplTest: {type: typeinfo, class: org.apache.flink.api.common.serialization.SerializerConfigImplTest$TestTypeInfoFactory}}";
        SerializerConfig serializerConfig = this.getConfiguredSerializerConfig(serializationConfigStr);
        Assertions.assertThat((Map)serializerConfig.getRegisteredTypeInfoFactories()).containsExactly(new Map.Entry[]{new AbstractMap.SimpleEntry<Class<SerializerConfigImplTest>, Class<TestTypeInfoFactory>>(SerializerConfigImplTest.class, TestTypeInfoFactory.class)});
    }

    @Test
    void testLoadingSerializationConfigWithLegacyParser() {
        GlobalConfiguration.setStandardYaml((boolean)false);
        String serializationConfigStr = "{org.apache.flink.api.common.serialization.SerializerConfigImplTest: {type: pojo}, org.apache.flink.api.common.serialization.SerializerConfigImplTest$TestSerializer1: {type: pojo}}";
        Assertions.assertThatThrownBy(() -> this.getConfiguredSerializerConfig(serializationConfigStr)).isInstanceOf(UnsupportedOperationException.class);
        GlobalConfiguration.setStandardYaml((boolean)true);
    }

    @Test
    void testLoadingIllegalSerializationConfig() {
        String duplicateClassConfigStr = "[org.apache.flink.api.common.serialization.SerializerConfigImplTest: {type: pojo}, org.apache.flink.api.common.serialization.SerializerConfigImplTest: {type: pojo}]";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getConfiguredSerializerConfig(duplicateClassConfigStr)).isInstanceOf(IllegalArgumentException.class)).hasRootCauseMessage("Duplicated serializer for the same class.");
        String nullTypeConfigStr = "{org.apache.flink.api.common.serialization.SerializerConfigImplTest: {class: org.apache.flink.api.common.serialization.SerializerConfigImplTest$TestTypeInfoFactory}}";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getConfiguredSerializerConfig(nullTypeConfigStr)).isInstanceOf(IllegalArgumentException.class)).hasRootCauseMessage("Serializer type not specified for class org.apache.flink.api.common.serialization.SerializerConfigImplTest");
        String unsupportedTypeConfigStr = "{org.apache.flink.api.common.serialization.SerializerConfigImplTest: {type: random}}";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getConfiguredSerializerConfig(unsupportedTypeConfigStr)).isInstanceOf(IllegalArgumentException.class)).hasRootCauseMessage("Unsupported serializer type random for class org.apache.flink.api.common.serialization.SerializerConfigImplTest");
    }

    private SerializerConfig getConfiguredSerializerConfig(String serializationConfigStr) {
        Configuration configuration = new Configuration();
        configuration.setString(PipelineOptions.SERIALIZATION_CONFIG.key(), serializationConfigStr);
        SerializerConfigImpl serializerConfig = new SerializerConfigImpl();
        serializerConfig.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        return serializerConfig;
    }

    private static class TestTypeInfoFactory
    extends TypeInfoFactory<SerializerConfigImplTest> {
        private TestTypeInfoFactory() {
        }

        public TypeInformation<SerializerConfigImplTest> createTypeInfo(Type t, Map<String, TypeInformation<?>> genericParameters) {
            return null;
        }
    }

    private static class TestSerializer3
    extends Serializer<TestSerializer2>
    implements Serializable {
        private TestSerializer3() {
        }

        public void write(Kryo kryo, Output output, TestSerializer2 object) {
        }

        public TestSerializer2 read(Kryo kryo, Input input, Class<TestSerializer2> type) {
            return null;
        }
    }

    private static class TestSerializer2
    extends Serializer<TestSerializer1>
    implements Serializable {
        private TestSerializer2() {
        }

        public void write(Kryo kryo, Output output, TestSerializer1 object) {
        }

        public TestSerializer1 read(Kryo kryo, Input input, Class<TestSerializer1> type) {
            return null;
        }
    }

    private static class TestSerializer1
    extends Serializer<SerializerConfigImplTest>
    implements Serializable {
        private TestSerializer1() {
        }

        public void write(Kryo kryo, Output output, SerializerConfigImplTest object) {
        }

        public SerializerConfigImplTest read(Kryo kryo, Input input, Class<SerializerConfigImplTest> type) {
            return null;
        }
    }
}

