/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.junit.Assert;
import org.junit.Test;

public class CompositeTypeSerializerSnapshotTest {
    @Test
    public void testIncompatiblePrecedence() throws IOException {
        TypeSerializer[] testNestedSerializers = new TypeSerializer[]{new NestedSerializer(TargetCompatibility.COMPATIBLE_AS_IS), new NestedSerializer(TargetCompatibility.COMPATIBLE_AFTER_MIGRATION), new NestedSerializer(TargetCompatibility.INCOMPATIBLE), new NestedSerializer(TargetCompatibility.COMPATIBLE_WITH_RECONFIGURED_SERIALIZER)};
        TypeSerializerSchemaCompatibility<String> compatibility = this.snapshotCompositeSerializerAndGetSchemaCompatibilityAfterRestore(testNestedSerializers, testNestedSerializers, CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS);
        Assert.assertTrue((boolean)compatibility.isIncompatible());
    }

    @Test
    public void testCompatibleAfterMigrationPrecedence() throws IOException {
        TypeSerializer[] testNestedSerializers = new TypeSerializer[]{new NestedSerializer(TargetCompatibility.COMPATIBLE_AS_IS), new NestedSerializer(TargetCompatibility.COMPATIBLE_AFTER_MIGRATION), new NestedSerializer(TargetCompatibility.COMPATIBLE_WITH_RECONFIGURED_SERIALIZER), new NestedSerializer(TargetCompatibility.COMPATIBLE_AS_IS)};
        TypeSerializerSchemaCompatibility<String> compatibility = this.snapshotCompositeSerializerAndGetSchemaCompatibilityAfterRestore(testNestedSerializers, testNestedSerializers, CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS);
        Assert.assertTrue((boolean)compatibility.isCompatibleAfterMigration());
    }

    @Test
    public void testCompatibleWithReconfiguredSerializerPrecedence() throws IOException {
        TypeSerializer[] testNestedSerializers = new TypeSerializer[]{new NestedSerializer(TargetCompatibility.COMPATIBLE_AS_IS), new NestedSerializer(TargetCompatibility.COMPATIBLE_WITH_RECONFIGURED_SERIALIZER), new NestedSerializer(TargetCompatibility.COMPATIBLE_AS_IS)};
        TypeSerializerSchemaCompatibility<String> compatibility = this.snapshotCompositeSerializerAndGetSchemaCompatibilityAfterRestore(testNestedSerializers, testNestedSerializers, CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS);
        Assert.assertTrue((boolean)compatibility.isCompatibleWithReconfiguredSerializer());
        TestCompositeTypeSerializer reconfiguredSerializer = (TestCompositeTypeSerializer)compatibility.getReconfiguredSerializer();
        TypeSerializer<?>[] reconfiguredNestedSerializers = reconfiguredSerializer.getNestedSerializers();
        Assert.assertSame(reconfiguredNestedSerializers[0].getClass(), RestoredNestedSerializer.class);
        Assert.assertSame(reconfiguredNestedSerializers[1].getClass(), ReconfiguredNestedSerializer.class);
        Assert.assertSame(reconfiguredNestedSerializers[2].getClass(), RestoredNestedSerializer.class);
    }

    @Test
    public void testCompatibleAsIsPrecedence() throws IOException {
        TypeSerializer[] testNestedSerializers = new TypeSerializer[]{new NestedSerializer(TargetCompatibility.COMPATIBLE_AS_IS), new NestedSerializer(TargetCompatibility.COMPATIBLE_AS_IS)};
        TypeSerializerSchemaCompatibility<String> compatibility = this.snapshotCompositeSerializerAndGetSchemaCompatibilityAfterRestore(testNestedSerializers, testNestedSerializers, CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS);
        Assert.assertTrue((boolean)compatibility.isCompatibleAsIs());
    }

    @Test
    public void testOuterSnapshotIncompatiblePrecedence() throws IOException {
        TypeSerializer[] testNestedSerializers = new TypeSerializer[]{new NestedSerializer(TargetCompatibility.COMPATIBLE_AS_IS)};
        TypeSerializerSchemaCompatibility<String> compatibility = this.snapshotCompositeSerializerAndGetSchemaCompatibilityAfterRestore(testNestedSerializers, testNestedSerializers, CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.INCOMPATIBLE);
        Assert.assertTrue((boolean)compatibility.isIncompatible());
    }

    @Test
    public void testOuterSnapshotRequiresMigrationPrecedence() throws IOException {
        TypeSerializer[] testNestedSerializers = new TypeSerializer[]{new NestedSerializer(TargetCompatibility.COMPATIBLE_WITH_RECONFIGURED_SERIALIZER)};
        TypeSerializerSchemaCompatibility<String> compatibility = this.snapshotCompositeSerializerAndGetSchemaCompatibilityAfterRestore(testNestedSerializers, testNestedSerializers, CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AFTER_MIGRATION);
        Assert.assertTrue((boolean)compatibility.isCompatibleAfterMigration());
    }

    @Test
    public void testNestedFieldSerializerArityMismatchPrecedence() throws IOException {
        TypeSerializer[] initialNestedSerializers = new TypeSerializer[]{new NestedSerializer(TargetCompatibility.COMPATIBLE_AS_IS)};
        TypeSerializer[] newNestedSerializers = new TypeSerializer[]{new NestedSerializer(TargetCompatibility.COMPATIBLE_AS_IS), new NestedSerializer(TargetCompatibility.COMPATIBLE_AS_IS), new NestedSerializer(TargetCompatibility.COMPATIBLE_AS_IS)};
        TypeSerializerSchemaCompatibility<String> compatibility = this.snapshotCompositeSerializerAndGetSchemaCompatibilityAfterRestore(initialNestedSerializers, newNestedSerializers, CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS);
        Assert.assertTrue((boolean)compatibility.isIncompatible());
    }

    private TypeSerializerSchemaCompatibility<String> snapshotCompositeSerializerAndGetSchemaCompatibilityAfterRestore(TypeSerializer<?>[] initialNestedSerializers, TypeSerializer<?>[] newNestedSerializer, CompositeTypeSerializerSnapshot.OuterSchemaCompatibility mockOuterSchemaCompatibilityResult) throws IOException {
        TestCompositeTypeSerializer testSerializer = new TestCompositeTypeSerializer(initialNestedSerializers);
        TypeSerializerSnapshot testSerializerSnapshot = testSerializer.snapshotConfiguration();
        DataOutputSerializer out = new DataOutputSerializer(128);
        TypeSerializerSnapshot.writeVersionedSnapshot((DataOutputView)out, testSerializerSnapshot);
        DataInputDeserializer in = new DataInputDeserializer(out.getCopyOfBuffer());
        testSerializerSnapshot = TypeSerializerSnapshot.readVersionedSnapshot((DataInputView)in, (ClassLoader)Thread.currentThread().getContextClassLoader());
        TestCompositeTypeSerializer newTestSerializer = new TestCompositeTypeSerializer(mockOuterSchemaCompatibilityResult, newNestedSerializer);
        return newTestSerializer.snapshotConfiguration().resolveSchemaCompatibility(testSerializerSnapshot);
    }

    @Test
    public void testRestoreCompositeTypeSerializer() throws IOException {
        TypeSerializer[] testNestedSerializers = new TypeSerializer[]{new NestedSerializer(TargetCompatibility.COMPATIBLE_AS_IS), new NestedSerializer(TargetCompatibility.INCOMPATIBLE), new NestedSerializer(TargetCompatibility.COMPATIBLE_AFTER_MIGRATION)};
        TestCompositeTypeSerializer testSerializer = new TestCompositeTypeSerializer(testNestedSerializers);
        TypeSerializerSnapshot testSerializerSnapshot = testSerializer.snapshotConfiguration();
        DataOutputSerializer out = new DataOutputSerializer(128);
        TypeSerializerSnapshot.writeVersionedSnapshot((DataOutputView)out, testSerializerSnapshot);
        DataInputDeserializer in = new DataInputDeserializer(out.getCopyOfBuffer());
        testSerializerSnapshot = TypeSerializerSnapshot.readVersionedSnapshot((DataInputView)in, (ClassLoader)Thread.currentThread().getContextClassLoader());
        testSerializer = (TestCompositeTypeSerializer)testSerializerSnapshot.restoreSerializer();
        Assert.assertTrue((testSerializer.getNestedSerializers()[0].getClass() == RestoredNestedSerializer.class ? 1 : 0) != 0);
        Assert.assertTrue((testSerializer.getNestedSerializers()[1].getClass() == RestoredNestedSerializer.class ? 1 : 0) != 0);
        Assert.assertTrue((testSerializer.getNestedSerializers()[2].getClass() == RestoredNestedSerializer.class ? 1 : 0) != 0);
    }

    static class RestoredNestedSerializer
    extends NestedSerializer {
        private static final long serialVersionUID = -1396401178636869659L;

        public RestoredNestedSerializer(TargetCompatibility targetCompatibility) {
            super(targetCompatibility);
        }
    }

    static class ReconfiguredNestedSerializer
    extends NestedSerializer {
        private static final long serialVersionUID = -1396401178636869659L;

        public ReconfiguredNestedSerializer(TargetCompatibility targetCompatibility) {
            super(targetCompatibility);
        }
    }

    public static class NestedSerializerSnapshot
    implements TypeSerializerSnapshot<String> {
        private TargetCompatibility targetCompatibility;

        public NestedSerializerSnapshot() {
        }

        public NestedSerializerSnapshot(TargetCompatibility targetCompatibility) {
            this.targetCompatibility = targetCompatibility;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            out.writeInt(this.targetCompatibility.ordinal());
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.targetCompatibility = TargetCompatibility.values()[in.readInt()];
        }

        public TypeSerializerSchemaCompatibility<String> resolveSchemaCompatibility(TypeSerializerSnapshot<String> oldSerializerSnapshot) {
            if (oldSerializerSnapshot.getClass() == NestedSerializerSnapshot.class) {
                switch (this.targetCompatibility) {
                    case COMPATIBLE_AS_IS: {
                        return TypeSerializerSchemaCompatibility.compatibleAsIs();
                    }
                    case COMPATIBLE_AFTER_MIGRATION: {
                        return TypeSerializerSchemaCompatibility.compatibleAfterMigration();
                    }
                    case COMPATIBLE_WITH_RECONFIGURED_SERIALIZER: {
                        return TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer((TypeSerializer)new ReconfiguredNestedSerializer(this.targetCompatibility));
                    }
                    case INCOMPATIBLE: {
                        return TypeSerializerSchemaCompatibility.incompatible();
                    }
                }
                throw new IllegalStateException("Unexpected target compatibility.");
            }
            throw new IllegalArgumentException("Expected the old serializer snapshot to be of class " + NestedSerializerSnapshot.class);
        }

        public TypeSerializer<String> restoreSerializer() {
            return new RestoredNestedSerializer(this.targetCompatibility);
        }

        public int getCurrentVersion() {
            return 1;
        }
    }

    public static class NestedSerializer
    extends TypeSerializer<String> {
        private static final long serialVersionUID = -6175000932620623446L;
        private static final StringSerializer delegateSerializer = StringSerializer.INSTANCE;
        private final TargetCompatibility targetCompatibility;

        NestedSerializer(TargetCompatibility targetCompatibility) {
            this.targetCompatibility = targetCompatibility;
        }

        public TypeSerializerSnapshot<String> snapshotConfiguration() {
            return new NestedSerializerSnapshot(this.targetCompatibility);
        }

        public String deserialize(String reuse, DataInputView source) throws IOException {
            return delegateSerializer.deserialize(reuse, source);
        }

        public String deserialize(DataInputView source) throws IOException {
            return delegateSerializer.deserialize(source);
        }

        public void serialize(String record, DataOutputView target) throws IOException {
            delegateSerializer.serialize(record, target);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            delegateSerializer.copy(source, target);
        }

        public String copy(String from) {
            return delegateSerializer.copy(from);
        }

        public String copy(String from, String reuse) {
            return delegateSerializer.copy(from, reuse);
        }

        public String createInstance() {
            return delegateSerializer.createInstance();
        }

        public TypeSerializer<String> duplicate() {
            return this;
        }

        public boolean isImmutableType() {
            return false;
        }

        public int getLength() {
            return 0;
        }

        public boolean equals(Object obj) {
            return this.targetCompatibility == ((NestedSerializer)((Object)obj)).targetCompatibility;
        }

        public int hashCode() {
            return this.targetCompatibility.hashCode();
        }
    }

    public static enum TargetCompatibility {
        COMPATIBLE_AS_IS,
        COMPATIBLE_AFTER_MIGRATION,
        COMPATIBLE_WITH_RECONFIGURED_SERIALIZER,
        INCOMPATIBLE;

    }

    public static class TestCompositeTypeSerializerSnapshot
    extends CompositeTypeSerializerSnapshot<String, TestCompositeTypeSerializer> {
        private CompositeTypeSerializerSnapshot.OuterSchemaCompatibility mockOuterSchemaCompatibility;

        public TestCompositeTypeSerializerSnapshot() {
        }

        TestCompositeTypeSerializerSnapshot(TestCompositeTypeSerializer serializer) {
            super((TypeSerializer)serializer);
            this.mockOuterSchemaCompatibility = serializer.getMockOuterSchemaCompatibility();
        }

        protected TestCompositeTypeSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            return new TestCompositeTypeSerializer(this.mockOuterSchemaCompatibility, nestedSerializers);
        }

        protected TypeSerializer<?>[] getNestedSerializers(TestCompositeTypeSerializer outerSerializer) {
            return outerSerializer.getNestedSerializers();
        }

        protected void writeOuterSnapshot(DataOutputView out) throws IOException {
            out.writeInt(this.mockOuterSchemaCompatibility.ordinal());
        }

        public void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            Assert.assertEquals((long)this.getCurrentOuterSnapshotVersion(), (long)readOuterSnapshotVersion);
            this.mockOuterSchemaCompatibility = CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.values()[in.readInt()];
        }

        protected CompositeTypeSerializerSnapshot.OuterSchemaCompatibility resolveOuterSchemaCompatibility(TypeSerializerSnapshot<String> oldSerializerSnapshot) {
            return this.mockOuterSchemaCompatibility;
        }

        public int getCurrentOuterSnapshotVersion() {
            return 1;
        }
    }

    public static class TestCompositeTypeSerializer
    extends TypeSerializer<String> {
        private static final long serialVersionUID = -545688468997398105L;
        private static final StringSerializer delegateSerializer = StringSerializer.INSTANCE;
        private final CompositeTypeSerializerSnapshot.OuterSchemaCompatibility mockOuterSchemaCompatibility;
        private final TypeSerializer<?>[] nestedSerializers;

        TestCompositeTypeSerializer(TypeSerializer<?>[] nestedSerializers) {
            this.mockOuterSchemaCompatibility = CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS;
            this.nestedSerializers = nestedSerializers;
        }

        TestCompositeTypeSerializer(CompositeTypeSerializerSnapshot.OuterSchemaCompatibility mockOuterSchemaCompatibility, TypeSerializer<?>[] nestedSerializers) {
            this.mockOuterSchemaCompatibility = mockOuterSchemaCompatibility;
            this.nestedSerializers = nestedSerializers;
        }

        public CompositeTypeSerializerSnapshot.OuterSchemaCompatibility getMockOuterSchemaCompatibility() {
            return this.mockOuterSchemaCompatibility;
        }

        TypeSerializer<?>[] getNestedSerializers() {
            return this.nestedSerializers;
        }

        public TypeSerializerSnapshot<String> snapshotConfiguration() {
            return new TestCompositeTypeSerializerSnapshot(this);
        }

        public String deserialize(String reuse, DataInputView source) throws IOException {
            return delegateSerializer.deserialize(reuse, source);
        }

        public String deserialize(DataInputView source) throws IOException {
            return delegateSerializer.deserialize(source);
        }

        public void serialize(String record, DataOutputView target) throws IOException {
            delegateSerializer.serialize(record, target);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            delegateSerializer.copy(source, target);
        }

        public String copy(String from) {
            return delegateSerializer.copy(from);
        }

        public String copy(String from, String reuse) {
            return delegateSerializer.copy(from, reuse);
        }

        public String createInstance() {
            return delegateSerializer.createInstance();
        }

        public TypeSerializer<String> duplicate() {
            return this;
        }

        public boolean isImmutableType() {
            return false;
        }

        public int getLength() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TestCompositeTypeSerializer) {
                return Arrays.equals(this.nestedSerializers, ((TestCompositeTypeSerializer)((Object)obj)).getNestedSerializers());
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.nestedSerializers);
        }
    }
}

