/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.junit.jupiter.api.Test;

public abstract class SerializerTestInstance<T>
extends SerializerTestBase<T> {
    private final TypeSerializer<T> serializer;
    private final Class<T> typeClass;
    private final int length;
    private final T[] testData;

    @SafeVarargs
    public SerializerTestInstance(TypeSerializer<T> serializer, Class<T> typeClass, int length, T ... testData) {
        this(new DeeplyEqualsChecker(), serializer, typeClass, length, testData);
    }

    @SafeVarargs
    public SerializerTestInstance(DeeplyEqualsChecker checker, TypeSerializer<T> serializer, Class<T> typeClass, int length, T ... testData) {
        super(checker);
        this.serializer = serializer;
        this.typeClass = typeClass;
        this.length = length;
        this.testData = testData;
    }

    @Override
    protected TypeSerializer<T> createSerializer() {
        return this.serializer;
    }

    @Override
    protected int getLength() {
        return this.length;
    }

    @Override
    protected Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    protected T[] getTestData() {
        return this.testData;
    }

    public void testAll() {
        for (Method method : SerializerTestBase.class.getMethods()) {
            if (method.getAnnotation(Test.class) == null) continue;
            try {
                method.invoke((Object)this, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to invoke test " + method.getName(), e);
            }
            catch (InvocationTargetException e) {
                SerializerTestInstance.sneakyThrow(e.getCause());
            }
        }
    }

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }
}

