/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.dag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.core.testutils.OneShotLatch;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TransformationTest {
    private Transformation<Void> transformation;

    TransformationTest() {
    }

    @BeforeEach
    public void setUp() {
        this.transformation = new TestTransformation<Void>("t", null, 1);
    }

    @Test
    void testGetNewNodeIdIsThreadSafe() throws Exception {
        int numThreads = 10;
        int numIdsPerThread = 100;
        ArrayList<1> threads = new ArrayList<1>();
        final OneShotLatch startLatch = new OneShotLatch();
        final List idLists = Collections.synchronizedList(new ArrayList());
        for (int x = 0; x < 10; ++x) {
            threads.add(new CheckedThread(){

                public void go() throws Exception {
                    startLatch.await();
                    ArrayList<Integer> ids = new ArrayList<Integer>();
                    for (int c = 0; c < 100; ++c) {
                        ids.add(Transformation.getNewNodeId());
                    }
                    idLists.add(ids);
                }
            });
        }
        threads.forEach(Thread::start);
        startLatch.trigger();
        for (CheckedThread checkedThread : threads) {
            checkedThread.sync();
        }
        Set deduplicatedIds = idLists.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Assertions.assertThat((int)1000).isEqualTo(deduplicatedIds.size());
    }

    @Test
    void testDeclareManagedMemoryUseCase() {
        this.transformation.declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.OPERATOR, 123);
        this.transformation.declareManagedMemoryUseCaseAtSlotScope(ManagedMemoryUseCase.STATE_BACKEND);
        Assertions.assertThat((Integer)((Integer)this.transformation.getManagedMemoryOperatorScopeUseCaseWeights().get(ManagedMemoryUseCase.OPERATOR))).isEqualTo(123);
        Assertions.assertThat((Collection)this.transformation.getManagedMemorySlotScopeUseCases()).contains((Object[])new ManagedMemoryUseCase[]{ManagedMemoryUseCase.STATE_BACKEND});
    }

    @Test
    void testDeclareManagedMemoryOperatorScopeUseCaseFailWrongScope() {
        Assertions.assertThatThrownBy(() -> this.transformation.declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.PYTHON, 123)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testDeclareManagedMemoryOperatorScopeUseCaseFailZeroWeight() {
        Assertions.assertThatThrownBy(() -> this.transformation.declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.OPERATOR, 0)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testDeclareManagedMemoryOperatorScopeUseCaseFailNegativeWeight() {
        Assertions.assertThatThrownBy(() -> this.transformation.declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.OPERATOR, -1)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testDeclareManagedMemorySlotScopeUseCaseFailWrongScope() {
        Assertions.assertThatThrownBy(() -> this.transformation.declareManagedMemoryUseCaseAtSlotScope(ManagedMemoryUseCase.OPERATOR)).isInstanceOf(IllegalArgumentException.class);
    }

    private static class TestTransformation<T>
    extends Transformation<T> {
        public TestTransformation(String name, TypeInformation<T> outputType, int parallelism) {
            super(name, outputType, parallelism);
        }

        protected List<Transformation<?>> getTransitivePredecessorsInternal() {
            return Collections.emptyList();
        }

        public List<Transformation<?>> getInputs() {
            return Collections.emptyList();
        }
    }
}

