/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConfigurationConversionsTest {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final long TOO_LONG = 0x80000009L;
    private static final double TOO_LONG_DOUBLE = Double.MAX_VALUE;
    private Configuration pc;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Parameterized.Parameter
    public TestSpec<?> testSpec;

    @Before
    public void init() {
        this.pc = new Configuration();
        this.pc.setInteger("int", 5);
        this.pc.setLong("long", 15L);
        this.pc.setLong("too_long", 0x80000009L);
        this.pc.setFloat("float", 2.1456776f);
        this.pc.setDouble("double", Math.PI);
        this.pc.setDouble("negative_double", -1.0);
        this.pc.setDouble("zero", 0.0);
        this.pc.setDouble("too_long_double", Double.MAX_VALUE);
        this.pc.setString("string", "42");
        this.pc.setString("non_convertible_string", "bcdefg&&");
        this.pc.setBoolean("boolean", true);
    }

    @Parameterized.Parameters
    public static Collection<TestSpec> getSpecs() {
        return Arrays.asList(TestSpec.whenAccessed(conf -> conf.getInteger("int", 0)).expect(5), TestSpec.whenAccessed(conf -> conf.getLong("int", 0L)).expect(5L), TestSpec.whenAccessed(conf -> Float.valueOf(conf.getFloat("int", 0.0f))).expect(Float.valueOf(5.0f)), TestSpec.whenAccessed(conf -> conf.getDouble("int", 0.0)).expect(5.0), TestSpec.whenAccessed(conf -> conf.getBoolean("int", true)).expectException("Unrecognized option for boolean: 5. Expected either true or false(case insensitive)"), TestSpec.whenAccessed(conf -> conf.getString("int", "0")).expect("5"), TestSpec.whenAccessed(conf -> conf.getBytes("int", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 5 as a byte[] value"), TestSpec.whenAccessed(conf -> conf.getClass("int", ConfigurationConversionsTest.class, ConfigurationConversionsTest.class.getClassLoader())).expectException("Configuration cannot evaluate object of class class java.lang.Integer as a class name"), TestSpec.whenAccessed(conf -> conf.getInteger("long", 0)).expect(15), TestSpec.whenAccessed(conf -> conf.getLong("long", 0L)).expect(15L), TestSpec.whenAccessed(conf -> Float.valueOf(conf.getFloat("long", 0.0f))).expect(Float.valueOf(15.0f)), TestSpec.whenAccessed(conf -> conf.getDouble("long", 0.0)).expect(15.0), TestSpec.whenAccessed(conf -> conf.getBoolean("long", true)).expectException("Unrecognized option for boolean: 15. Expected either true or false(case insensitive)"), TestSpec.whenAccessed(conf -> conf.getString("long", "0")).expect("15"), TestSpec.whenAccessed(conf -> conf.getBytes("long", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 15 as a byte[] value"), TestSpec.whenAccessed(conf -> conf.getClass("long", ConfigurationConversionsTest.class, ConfigurationConversionsTest.class.getClassLoader())).expectException("Configuration cannot evaluate object of class class java.lang.Long as a class name"), TestSpec.whenAccessed(conf -> conf.getInteger("too_long", 0)).expectException("Configuration value 2147483657 overflows/underflows the integer type"), TestSpec.whenAccessed(conf -> conf.getLong("too_long", 0L)).expect(0x80000009L), TestSpec.whenAccessed(conf -> Float.valueOf(conf.getFloat("too_long", 0.0f))).expect(Float.valueOf(2.1474836E9f)), TestSpec.whenAccessed(conf -> conf.getDouble("too_long", 0.0)).expect(2.147483657E9), TestSpec.whenAccessed(conf -> conf.getBoolean("too_long", true)).expectException("Unrecognized option for boolean: 2147483657. Expected either true or false(case insensitive)"), TestSpec.whenAccessed(conf -> conf.getString("too_long", "0")).expect(String.valueOf(0x80000009L)), TestSpec.whenAccessed(conf -> conf.getBytes("too_long", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 2147483657 as a byte[] value"), TestSpec.whenAccessed(conf -> conf.getClass("too_long", ConfigurationConversionsTest.class, ConfigurationConversionsTest.class.getClassLoader())).expectException("Configuration cannot evaluate object of class class java.lang.Long as a class name"), TestSpec.whenAccessed(conf -> conf.getInteger("float", 0)).expectException("For input string: \"2.1456776\"", NumberFormatException.class), TestSpec.whenAccessed(conf -> conf.getLong("float", 0L)).expectException("For input string: \"2.1456776\"", NumberFormatException.class), TestSpec.whenAccessed(conf -> Float.valueOf(conf.getFloat("float", 0.0f))).expect(Float.valueOf(2.1456776f)), TestSpec.whenAccessed(conf -> conf.getDouble("float", 0.0)).expect((Double)Matchers.closeTo((double)2.1456775, (double)1.0E-7)), TestSpec.whenAccessed(conf -> conf.getBoolean("float", true)).expectException("Unrecognized option for boolean: 2.1456776. Expected either true or false(case insensitive)"), TestSpec.whenAccessed(conf -> conf.getString("float", "0")).expect((String)CoreMatchers.startsWith((String)"2.145677")), TestSpec.whenAccessed(conf -> conf.getBytes("float", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 2.1456776 as a byte[] value"), TestSpec.whenAccessed(conf -> conf.getClass("float", ConfigurationConversionsTest.class, ConfigurationConversionsTest.class.getClassLoader())).expectException("onfiguration cannot evaluate object of class class java.lang.Float as a class name"), TestSpec.whenAccessed(conf -> conf.getInteger("double", 0)).expectException("For input string: \"3.141592653589793\"", NumberFormatException.class), TestSpec.whenAccessed(conf -> conf.getLong("double", 0L)).expectException("For input string: \"3.141592653589793\"", NumberFormatException.class), TestSpec.whenAccessed(conf -> Float.valueOf(conf.getFloat("double", 0.0f))).expect((Float)((Object)new IsCloseTo(3.141592f, 1.0E-6f))), TestSpec.whenAccessed(conf -> conf.getDouble("double", 0.0)).expect(Math.PI), TestSpec.whenAccessed(conf -> conf.getBoolean("double", true)).expectException("Unrecognized option for boolean: 3.141592653589793. Expected either true or false(case insensitive)"), TestSpec.whenAccessed(conf -> conf.getString("double", "0")).expect((String)CoreMatchers.startsWith((String)"3.1415926535")), TestSpec.whenAccessed(conf -> conf.getBytes("double", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 3.141592653589793 as a byte[] value"), TestSpec.whenAccessed(conf -> conf.getClass("double", ConfigurationConversionsTest.class, ConfigurationConversionsTest.class.getClassLoader())).expectException("onfiguration cannot evaluate object of class class java.lang.Double as a class name"), TestSpec.whenAccessed(conf -> conf.getInteger("negative_double", 0)).expectException("For input string: \"-1.0\"", NumberFormatException.class), TestSpec.whenAccessed(conf -> conf.getLong("negative_double", 0L)).expectException("For input string: \"-1.0\"", NumberFormatException.class), TestSpec.whenAccessed(conf -> Float.valueOf(conf.getFloat("negative_double", 0.0f))).expect((Float)((Object)new IsCloseTo(-1.0f, 1.0E-6f))), TestSpec.whenAccessed(conf -> conf.getDouble("negative_double", 0.0)).expect(-1.0), TestSpec.whenAccessed(conf -> conf.getBoolean("negative_double", true)).expectException("Unrecognized option for boolean: -1.0. Expected either true or false(case insensitive)"), TestSpec.whenAccessed(conf -> conf.getString("negative_double", "0")).expect((String)CoreMatchers.startsWith((String)"-1")), TestSpec.whenAccessed(conf -> conf.getBytes("negative_double", EMPTY_BYTES)).expectException("Configuration cannot evaluate value -1.0 as a byte[] value"), TestSpec.whenAccessed(conf -> conf.getClass("negative_double", ConfigurationConversionsTest.class, ConfigurationConversionsTest.class.getClassLoader())).expectException("Configuration cannot evaluate object of class class java.lang.Double as a class name"), TestSpec.whenAccessed(conf -> conf.getInteger("zero", 0)).expectException("For input string: \"0.0\"", NumberFormatException.class), TestSpec.whenAccessed(conf -> conf.getLong("zero", 0L)).expectException("For input string: \"0.0\"", NumberFormatException.class), TestSpec.whenAccessed(conf -> Float.valueOf(conf.getFloat("zero", 0.0f))).expect((Float)((Object)new IsCloseTo(0.0f, 1.0E-6f))), TestSpec.whenAccessed(conf -> conf.getDouble("zero", 0.0)).expect(0.0), TestSpec.whenAccessed(conf -> conf.getBoolean("zero", true)).expectException("Unrecognized option for boolean: 0.0. Expected either true or false(case insensitive)"), TestSpec.whenAccessed(conf -> conf.getString("zero", "0")).expect((String)CoreMatchers.startsWith((String)"0")), TestSpec.whenAccessed(conf -> conf.getBytes("zero", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 0.0 as a byte[] value"), TestSpec.whenAccessed(conf -> conf.getClass("zero", ConfigurationConversionsTest.class, ConfigurationConversionsTest.class.getClassLoader())).expectException("Configuration cannot evaluate object of class class java.lang.Double as a class name"), TestSpec.whenAccessed(conf -> conf.getInteger("too_long_double", 0)).expectException("For input string: \"1.7976931348623157E308\"", NumberFormatException.class), TestSpec.whenAccessed(conf -> conf.getLong("too_long_double", 0L)).expectException("For input string: \"1.7976931348623157E308\"", NumberFormatException.class), TestSpec.whenAccessed(conf -> Float.valueOf(conf.getFloat("too_long_double", 0.0f))).expectException("Configuration value 1.7976931348623157E308 overflows/underflows the float type."), TestSpec.whenAccessed(conf -> conf.getDouble("too_long_double", 0.0)).expect((Double)Double.MAX_VALUE), TestSpec.whenAccessed(conf -> conf.getBoolean("too_long_double", true)).expectException("Unrecognized option for boolean: 1.7976931348623157E308. Expected either true or false(case insensitive)"), TestSpec.whenAccessed(conf -> conf.getString("too_long_double", "0")).expect(String.valueOf(Double.MAX_VALUE)), TestSpec.whenAccessed(conf -> conf.getBytes("too_long_double", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 1.7976931348623157E308 as a byte[] value"), TestSpec.whenAccessed(conf -> conf.getClass("too_long_double", ConfigurationConversionsTest.class, ConfigurationConversionsTest.class.getClassLoader())).expectException("Configuration cannot evaluate object of class class java.lang.Double as a class name"), TestSpec.whenAccessed(conf -> conf.getInteger("string", 0)).expect(42), TestSpec.whenAccessed(conf -> conf.getLong("string", 0L)).expect(42L), TestSpec.whenAccessed(conf -> Float.valueOf(conf.getFloat("string", 0.0f))).expect(Float.valueOf(42.0f)), TestSpec.whenAccessed(conf -> conf.getDouble("string", 0.0)).expect(42.0), TestSpec.whenAccessed(conf -> conf.getBoolean("string", true)).expectException("Unrecognized option for boolean: 42. Expected either true or false(case insensitive)"), TestSpec.whenAccessed(conf -> conf.getString("string", "0")).expect("42"), TestSpec.whenAccessed(conf -> conf.getBytes("string", EMPTY_BYTES)).expectException("Configuration cannot evaluate value 42 as a byte[] value"), TestSpec.whenAccessed(conf -> conf.getClass("string", ConfigurationConversionsTest.class, ConfigurationConversionsTest.class.getClassLoader())).expectException("42", ClassNotFoundException.class), TestSpec.whenAccessed(conf -> conf.getInteger("non_convertible_string", 0)).expectException("For input string: \"bcdefg&&\"", NumberFormatException.class), TestSpec.whenAccessed(conf -> conf.getLong("non_convertible_string", 0L)).expectException("For input string: \"bcdefg&&\"", NumberFormatException.class), TestSpec.whenAccessed(conf -> Float.valueOf(conf.getFloat("non_convertible_string", 0.0f))).expectException("For input string: \"bcdefg&&\"", NumberFormatException.class), TestSpec.whenAccessed(conf -> conf.getDouble("non_convertible_string", 0.0)).expectException("For input string: \"bcdefg&&\"", NumberFormatException.class), TestSpec.whenAccessed(conf -> conf.getBoolean("non_convertible_string", true)).expectException("Unrecognized option for boolean: bcdefg&&. Expected either true or false(case insensitive)"), TestSpec.whenAccessed(conf -> conf.getString("non_convertible_string", "0")).expect("bcdefg&&"), TestSpec.whenAccessed(conf -> conf.getBytes("non_convertible_string", EMPTY_BYTES)).expectException("Configuration cannot evaluate value bcdefg&& as a byte[] value"), TestSpec.whenAccessed(conf -> conf.getClass("non_convertible_string", ConfigurationConversionsTest.class, ConfigurationConversionsTest.class.getClassLoader())).expectException("bcdefg&&", ClassNotFoundException.class), TestSpec.whenAccessed(conf -> conf.getInteger("boolean", 0)).expectException("For input string: \"true\""), TestSpec.whenAccessed(conf -> conf.getLong("boolean", 0L)).expectException("For input string: \"true\""), TestSpec.whenAccessed(conf -> Float.valueOf(conf.getFloat("boolean", 0.0f))).expectException("For input string: \"true\""), TestSpec.whenAccessed(conf -> conf.getDouble("boolean", 0.0)).expectException("For input string: \"true\""), TestSpec.whenAccessed(conf -> conf.getBoolean("boolean", false)).expect(true), TestSpec.whenAccessed(conf -> conf.getString("boolean", "0")).expect("true"), TestSpec.whenAccessed(conf -> conf.getBytes("boolean", EMPTY_BYTES)).expectException("Configuration cannot evaluate value true as a byte[] value"), TestSpec.whenAccessed(conf -> conf.getClass("boolean", ConfigurationConversionsTest.class, ConfigurationConversionsTest.class.getClassLoader())).expectException("Configuration cannot evaluate object of class class java.lang.Boolean as a class name"));
    }

    @Test
    public void testConversions() throws Exception {
        this.testSpec.getExpectedException().ifPresent(exception -> {
            this.thrown.expect(this.testSpec.getExceptionClass());
            this.thrown.expectMessage(exception);
        });
        this.testSpec.assertConfiguration(this.pc);
    }

    private static class TestSpec<T> {
        private final ConfigurationAccessor<T> configurationAccessor;
        private Matcher<T> matcher;
        @Nullable
        private String expectedException = null;
        @Nullable
        private Class<? extends Exception> exceptionClass;

        private TestSpec(ConfigurationAccessor<T> configurationAccessor) {
            this.configurationAccessor = configurationAccessor;
        }

        public static <T> TestSpec<T> whenAccessed(ConfigurationAccessor<T> configurationAccessor) {
            return new TestSpec<T>(configurationAccessor);
        }

        public TestSpec<T> expect(Matcher<T> expected) {
            this.matcher = expected;
            return this;
        }

        public TestSpec<T> expect(T expected) {
            this.matcher = CoreMatchers.equalTo(expected);
            return this;
        }

        public TestSpec<T> expectException(String message) {
            this.expectedException = message;
            this.exceptionClass = IllegalArgumentException.class;
            return this;
        }

        public TestSpec<T> expectException(String message, Class<? extends Exception> exceptionClass) {
            this.expectedException = message;
            this.exceptionClass = exceptionClass;
            return this;
        }

        public Optional<String> getExpectedException() {
            return Optional.ofNullable(this.expectedException);
        }

        @Nullable
        public Class<? extends Exception> getExceptionClass() {
            return this.exceptionClass;
        }

        void assertConfiguration(Configuration conf) throws Exception {
            Assert.assertThat(this.configurationAccessor.access(conf), this.matcher);
        }

        @FunctionalInterface
        private static interface ConfigurationAccessor<T> {
            public T access(Configuration var1) throws Exception;
        }
    }

    private static class IsCloseTo
    extends TypeSafeMatcher<Float> {
        private final float delta;
        private final float value;

        public IsCloseTo(float value, float error) {
            this.delta = error;
            this.value = value;
        }

        public boolean matchesSafely(Float item) {
            return this.actualDelta(item) <= 0.0;
        }

        public void describeMismatchSafely(Float item, Description mismatchDescription) {
            mismatchDescription.appendValue((Object)item).appendText(" differed by ").appendValue((Object)this.actualDelta(item));
        }

        public void describeTo(Description description) {
            description.appendText("a numeric value within ").appendValue((Object)Float.valueOf(this.delta)).appendText(" of ").appendValue((Object)Float.valueOf(this.value));
        }

        private double actualDelta(Float item) {
            return Math.abs(item.floatValue() - this.value) - this.delta;
        }
    }
}

