/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.junit.Assert;
import org.junit.Test;

public class CoreOptionsTest {
    @Test
    public void testGetParentFirstLoaderPatterns() {
        this.testParentFirst(CoreOptions::getParentFirstLoaderPatterns, (ConfigOption<List<String>>)CoreOptions.ALWAYS_PARENT_FIRST_LOADER_PATTERNS, (ConfigOption<List<String>>)CoreOptions.ALWAYS_PARENT_FIRST_LOADER_PATTERNS_ADDITIONAL);
    }

    @Test
    public void testGetPluginParentFirstLoaderPatterns() {
        this.testParentFirst(CoreOptions::getPluginParentFirstLoaderPatterns, (ConfigOption<List<String>>)CoreOptions.PLUGIN_ALWAYS_PARENT_FIRST_LOADER_PATTERNS, (ConfigOption<List<String>>)CoreOptions.PLUGIN_ALWAYS_PARENT_FIRST_LOADER_PATTERNS_ADDITIONAL);
    }

    private void testParentFirst(Function<Configuration, String[]> patternGetter, ConfigOption<List<String>> patternOption, ConfigOption<List<String>> additionalOption) {
        Configuration config = new Configuration();
        Assert.assertArrayEquals((Object[])((List)patternOption.defaultValue()).toArray(new String[0]), (Object[])patternGetter.apply(config));
        config.set(patternOption, Arrays.asList("hello", "world"));
        Assert.assertArrayEquals((Object[])new String[]{"hello", "world"}, (Object[])patternGetter.apply(config));
        config.set(additionalOption, Arrays.asList("how", "are", "you"));
        Assert.assertArrayEquals((Object[])new String[]{"hello", "world", "how", "are", "you"}, (Object[])patternGetter.apply(config));
        config.set(patternOption, Collections.emptyList());
        Assert.assertArrayEquals((Object[])new String[]{"how", "are", "you"}, (Object[])patternGetter.apply(config));
    }
}

