/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.UnsupportedFileSystemSchemeException;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FilesystemSchemeConfigTest
extends TestLogger {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    @After
    public void clearFsSettings() throws IOException {
        FileSystem.initialize((Configuration)new Configuration());
    }

    @Test
    public void testDefaultsToLocal() throws Exception {
        URI justPath = new URI(this.tempFolder.newFile().toURI().getPath());
        Assert.assertNull((Object)justPath.getScheme());
        FileSystem fs = FileSystem.get((URI)justPath);
        Assert.assertEquals((Object)"file", (Object)fs.getUri().getScheme());
    }

    @Test
    public void testExplicitlySetToLocal() throws Exception {
        Configuration conf = new Configuration();
        conf.set(CoreOptions.DEFAULT_FILESYSTEM_SCHEME, (Object)LocalFileSystem.getLocalFsURI().toString());
        FileSystem.initialize((Configuration)conf);
        URI justPath = new URI(this.tempFolder.newFile().toURI().getPath());
        Assert.assertNull((Object)justPath.getScheme());
        FileSystem fs = FileSystem.get((URI)justPath);
        Assert.assertEquals((Object)"file", (Object)fs.getUri().getScheme());
    }

    @Test
    public void testExplicitlySetToOther() throws Exception {
        Configuration conf = new Configuration();
        conf.set(CoreOptions.DEFAULT_FILESYSTEM_SCHEME, (Object)"otherFS://localhost:1234/");
        FileSystem.initialize((Configuration)conf);
        URI justPath = new URI(this.tempFolder.newFile().toURI().getPath());
        Assert.assertNull((Object)justPath.getScheme());
        try {
            FileSystem.get((URI)justPath);
            Assert.fail((String)"should have failed with an exception");
        }
        catch (UnsupportedFileSystemSchemeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("otherFS"));
        }
    }

    @Test
    public void testExplicitlyPathTakesPrecedence() throws Exception {
        Configuration conf = new Configuration();
        conf.set(CoreOptions.DEFAULT_FILESYSTEM_SCHEME, (Object)"otherFS://localhost:1234/");
        FileSystem.initialize((Configuration)conf);
        URI pathAndScheme = this.tempFolder.newFile().toURI();
        Assert.assertNotNull((Object)pathAndScheme.getScheme());
        FileSystem fs = FileSystem.get((URI)pathAndScheme);
        Assert.assertEquals((Object)"file", (Object)fs.getUri().getScheme());
    }
}

