/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.configuration.MemorySize;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MemorySizePrettyPrintingTest
extends TestLogger {
    @Parameterized.Parameter
    public MemorySize memorySize;
    @Parameterized.Parameter(value=1)
    public String expectedString;

    @Parameterized.Parameters
    public static Object[][] parameters() {
        return new Object[][]{{new MemorySize(MemorySize.MemoryUnit.KILO_BYTES.getMultiplier() + 1L), "1025 bytes"}, {new MemorySize(100L), "100 bytes"}, {new MemorySize(1024L), "1 kb"}, {new MemorySize(MemorySize.MemoryUnit.GIGA_BYTES.getMultiplier() + 1L), String.format("%d %s", MemorySize.MemoryUnit.GIGA_BYTES.getMultiplier() + 1L, "bytes")}, {new MemorySize(0L), "0 bytes"}};
    }

    @Test
    public void testFormatting() {
        Assert.assertThat((Object)this.memorySize.toString(), (Matcher)CoreMatchers.is((Object)this.expectedString));
    }
}

