/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class SecurityOptionsTest
extends TestLogger {
    @Test
    public void checkEnableSSL() {
        Configuration oldConf = new Configuration();
        oldConf.set(SecurityOptions.SSL_ENABLED, (Object)true);
        Assert.assertTrue((boolean)SecurityOptions.isInternalSSLEnabled((Configuration)oldConf));
        Assert.assertTrue((boolean)SecurityOptions.isRestSSLEnabled((Configuration)oldConf));
        Configuration newOptions = new Configuration();
        newOptions.set(SecurityOptions.SSL_INTERNAL_ENABLED, (Object)true);
        newOptions.set(SecurityOptions.SSL_REST_ENABLED, (Object)false);
        Assert.assertTrue((boolean)SecurityOptions.isInternalSSLEnabled((Configuration)newOptions));
        Assert.assertFalse((boolean)SecurityOptions.isRestSSLEnabled((Configuration)newOptions));
        Configuration precedence = new Configuration();
        precedence.set(SecurityOptions.SSL_ENABLED, (Object)true);
        precedence.set(SecurityOptions.SSL_INTERNAL_ENABLED, (Object)false);
        precedence.set(SecurityOptions.SSL_REST_ENABLED, (Object)false);
        Assert.assertFalse((boolean)SecurityOptions.isInternalSSLEnabled((Configuration)precedence));
        Assert.assertFalse((boolean)SecurityOptions.isRestSSLEnabled((Configuration)precedence));
    }

    @Test
    public void checkEnableRestSSLAuthentication() {
        Configuration noSSLOptions = new Configuration();
        noSSLOptions.set(SecurityOptions.SSL_REST_ENABLED, (Object)false);
        noSSLOptions.set(SecurityOptions.SSL_REST_AUTHENTICATION_ENABLED, (Object)true);
        Assert.assertFalse((boolean)SecurityOptions.isRestSSLAuthenticationEnabled((Configuration)noSSLOptions));
        Configuration defaultOptions = new Configuration();
        defaultOptions.set(SecurityOptions.SSL_REST_ENABLED, (Object)true);
        Assert.assertFalse((boolean)SecurityOptions.isRestSSLAuthenticationEnabled((Configuration)defaultOptions));
        Configuration options = new Configuration();
        options.set(SecurityOptions.SSL_REST_ENABLED, (Object)true);
        options.set(SecurityOptions.SSL_REST_AUTHENTICATION_ENABLED, (Object)true);
        Assert.assertTrue((boolean)SecurityOptions.isRestSSLAuthenticationEnabled((Configuration)options));
    }
}

