/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class UnmodifiableConfigurationTest
extends TestLogger {
    @Test
    public void testOverrideAddMethods() {
        try {
            Class<UnmodifiableConfiguration> clazz = UnmodifiableConfiguration.class;
            for (Method m : clazz.getMethods()) {
                if (!m.getName().startsWith("add")) continue;
                Assert.assertEquals(clazz, m.getDeclaringClass());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExceptionOnSet() {
        try {
            ConfigOption rawOption = ConfigOptions.key((String)"testkey").defaultValue((Object)"value");
            HashMap<Class<Object>, Object> parameters = new HashMap<Class<Object>, Object>();
            parameters.put(byte[].class, new byte[0]);
            parameters.put(Class.class, Object.class);
            parameters.put(Integer.TYPE, 0);
            parameters.put(Long.TYPE, 0L);
            parameters.put(Float.TYPE, Float.valueOf(0.0f));
            parameters.put(Double.TYPE, 0.0);
            parameters.put(String.class, "");
            parameters.put(Boolean.TYPE, false);
            Class<UnmodifiableConfiguration> clazz = UnmodifiableConfiguration.class;
            UnmodifiableConfiguration config = new UnmodifiableConfiguration(new Configuration());
            for (Method m : clazz.getMethods()) {
                if (!m.getName().startsWith("set") || m.getName().equals("set")) continue;
                Class<?> keyClass = m.getParameterTypes()[0];
                Class<?> parameterClass = m.getParameterTypes()[1];
                String key = keyClass == String.class ? "key" : rawOption;
                Object parameter = parameters.get(parameterClass);
                Assert.assertNotNull((String)("method " + m + " not covered by test"), parameter);
                try {
                    m.invoke((Object)config, key, parameter);
                    Assert.fail((String)"should fail with an exception");
                }
                catch (InvocationTargetException e) {
                    Assert.assertTrue((boolean)(e.getTargetException() instanceof UnsupportedOperationException));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

