/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.UUID;
import org.apache.flink.core.fs.RefCountedBufferingFileStream;
import org.apache.flink.core.fs.RefCountedFileWithStream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class RefCountedBufferingFileStreamTest {
    private static final int BUFFER_SIZE = 10;
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testSmallWritesGoToBuffer() throws IOException {
        RefCountedBufferingFileStream stream = this.getStreamToTest();
        byte[] contentToWrite = RefCountedBufferingFileStreamTest.bytesOf("hello");
        stream.write(contentToWrite);
        Assert.assertEquals((long)contentToWrite.length, (long)stream.getPositionInBuffer());
        Assert.assertEquals((long)contentToWrite.length, (long)stream.getPos());
        stream.close();
        stream.release();
    }

    @Test(expected=IOException.class)
    public void testExceptionWhenWritingToClosedFile() throws IOException {
        RefCountedBufferingFileStream stream = this.getStreamToTest();
        byte[] contentToWrite = RefCountedBufferingFileStreamTest.bytesOf("hello");
        stream.write(contentToWrite);
        Assert.assertEquals((long)contentToWrite.length, (long)stream.getPositionInBuffer());
        Assert.assertEquals((long)contentToWrite.length, (long)stream.getPos());
        stream.close();
        stream.write(contentToWrite);
    }

    @Test
    public void testBigWritesGoToFile() throws IOException {
        RefCountedBufferingFileStream stream = this.getStreamToTest();
        byte[] contentToWrite = RefCountedBufferingFileStreamTest.bytesOf("hello big world");
        stream.write(contentToWrite);
        Assert.assertEquals((long)0L, (long)stream.getPositionInBuffer());
        Assert.assertEquals((long)contentToWrite.length, (long)stream.getPos());
        stream.close();
        stream.release();
    }

    @Test
    public void testSpillingWhenBufferGetsFull() throws IOException {
        RefCountedBufferingFileStream stream = this.getStreamToTest();
        byte[] firstContentToWrite = RefCountedBufferingFileStreamTest.bytesOf("hello");
        stream.write(firstContentToWrite);
        Assert.assertEquals((long)firstContentToWrite.length, (long)stream.getPositionInBuffer());
        Assert.assertEquals((long)firstContentToWrite.length, (long)stream.getPos());
        byte[] secondContentToWrite = RefCountedBufferingFileStreamTest.bytesOf(" world!");
        stream.write(secondContentToWrite);
        Assert.assertEquals((long)secondContentToWrite.length, (long)stream.getPositionInBuffer());
        Assert.assertEquals((long)(firstContentToWrite.length + secondContentToWrite.length), (long)stream.getPos());
        stream.close();
        stream.release();
    }

    @Test
    public void testFlush() throws IOException {
        RefCountedBufferingFileStream stream = this.getStreamToTest();
        byte[] contentToWrite = RefCountedBufferingFileStreamTest.bytesOf("hello");
        stream.write(contentToWrite);
        Assert.assertEquals((long)contentToWrite.length, (long)stream.getPositionInBuffer());
        Assert.assertEquals((long)contentToWrite.length, (long)stream.getPos());
        stream.flush();
        Assert.assertEquals((long)0L, (long)stream.getPositionInBuffer());
        Assert.assertEquals((long)contentToWrite.length, (long)stream.getPos());
        byte[] contentRead = new byte[contentToWrite.length];
        new FileInputStream(stream.getInputFile()).read(contentRead, 0, contentRead.length);
        Assert.assertTrue((boolean)Arrays.equals(contentToWrite, contentRead));
        stream.release();
    }

    private RefCountedBufferingFileStream getStreamToTest() throws IOException {
        return new RefCountedBufferingFileStream(this.getRefCountedFileWithContent(), 10);
    }

    private RefCountedFileWithStream getRefCountedFileWithContent() throws IOException {
        File newFile = new File(this.temporaryFolder.getRoot(), ".tmp_" + UUID.randomUUID());
        OutputStream out = Files.newOutputStream(newFile.toPath(), StandardOpenOption.CREATE_NEW);
        return RefCountedFileWithStream.newFile((File)newFile, (OutputStream)out);
    }

    private static byte[] bytesOf(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }
}

