/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.PostVersionedIOReadableWritable;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.junit.Assert;
import org.junit.Test;

public class PostVersionedIOReadableWritableTest {
    @Test
    public void testReadVersioned() throws IOException {
        byte[] payload = "test-data".getBytes(StandardCharsets.UTF_8);
        byte[] serialized = this.serializeWithPostVersionedReadableWritable(payload);
        byte[] restored = this.restoreWithPostVersionedReadableWritable(serialized, payload.length);
        Assert.assertArrayEquals((byte[])payload, (byte[])restored);
    }

    @Test
    public void testReadNonVersioned() throws IOException {
        byte[] preVersionedPayload = new byte[]{0, 0, 2, 51};
        byte[] serialized = this.serializeWithNonVersionedReadableWritable(preVersionedPayload);
        byte[] restored = this.restoreWithPostVersionedReadableWritable(serialized, preVersionedPayload.length);
        Assert.assertArrayEquals((byte[])preVersionedPayload, (byte[])restored);
    }

    @Test
    public void testReadNonVersionedWithLongPayload() throws IOException {
        byte[] preVersionedPayload = "test-data".getBytes(StandardCharsets.UTF_8);
        byte[] serialized = this.serializeWithNonVersionedReadableWritable(preVersionedPayload);
        byte[] restored = this.restoreWithPostVersionedReadableWritable(serialized, preVersionedPayload.length);
        Assert.assertArrayEquals((byte[])preVersionedPayload, (byte[])restored);
    }

    @Test
    public void testReadNonVersionedWithShortPayload() throws IOException {
        byte[] preVersionedPayload = new byte[]{-15, -51};
        byte[] serialized = this.serializeWithNonVersionedReadableWritable(preVersionedPayload);
        byte[] restored = this.restoreWithPostVersionedReadableWritable(serialized, preVersionedPayload.length);
        Assert.assertArrayEquals((byte[])preVersionedPayload, (byte[])restored);
    }

    @Test
    public void testReadNonVersionedWithEmptyPayload() throws IOException {
        byte[] preVersionedPayload = new byte[]{};
        byte[] serialized = this.serializeWithNonVersionedReadableWritable(preVersionedPayload);
        byte[] restored = this.restoreWithPostVersionedReadableWritable(serialized, preVersionedPayload.length);
        Assert.assertArrayEquals((byte[])preVersionedPayload, (byte[])restored);
    }

    private byte[] serializeWithNonVersionedReadableWritable(byte[] payload) throws IOException {
        byte[] serialized;
        TestNonVersionedReadableWritable versionedReadableWritable = new TestNonVersionedReadableWritable(payload);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            versionedReadableWritable.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        return serialized;
    }

    private byte[] serializeWithPostVersionedReadableWritable(byte[] payload) throws IOException {
        byte[] serialized;
        TestPostVersionedReadableWritable versionedReadableWritable = new TestPostVersionedReadableWritable(payload);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            versionedReadableWritable.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        return serialized;
    }

    private byte[] restoreWithPostVersionedReadableWritable(byte[] serialized, int expectedLength) throws IOException {
        TestPostVersionedReadableWritable restoredVersionedReadableWritable = new TestPostVersionedReadableWritable(expectedLength);
        try (TestByteArrayInputStreamProducingOneByteAtATime in = new TestByteArrayInputStreamProducingOneByteAtATime(serialized);){
            restoredVersionedReadableWritable.read((InputStream)((Object)in));
        }
        return restoredVersionedReadableWritable.getData();
    }

    private static void assertEmpty(DataInputView in) throws IOException {
        try {
            in.readByte();
            Assert.fail();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    static class TestByteArrayInputStreamProducingOneByteAtATime
    extends ByteArrayInputStreamWithPos {
        public TestByteArrayInputStreamProducingOneByteAtATime(byte[] buf) {
            super(buf);
        }

        public int read(byte[] b, int off, int len) {
            return super.read(b, off, Math.min(len, 1));
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    }

    static class TestNonVersionedReadableWritable
    implements IOReadableWritable {
        private byte[] data;

        TestNonVersionedReadableWritable(byte[] data) {
            this.data = data;
        }

        public void write(DataOutputView out) throws IOException {
            out.write(this.data);
        }

        public void read(DataInputView in) throws IOException {
            in.readFully(this.data);
            PostVersionedIOReadableWritableTest.assertEmpty(in);
        }
    }

    static class TestPostVersionedReadableWritable
    extends PostVersionedIOReadableWritable {
        private static final int VERSION = 1;
        private byte[] data;

        TestPostVersionedReadableWritable(int len) {
            this.data = new byte[len];
        }

        TestPostVersionedReadableWritable(byte[] data) {
            this.data = data;
        }

        public int getVersion() {
            return 1;
        }

        public void write(DataOutputView out) throws IOException {
            super.write(out);
            out.write(this.data);
        }

        protected void read(DataInputView in, boolean wasVersioned) throws IOException {
            in.readFully(this.data);
            PostVersionedIOReadableWritableTest.assertEmpty(in);
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

