/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.junit.Assert;
import org.junit.Test;

public class MemorySegmentFactoryTest {
    @Test
    public void testWrapCopyChangingData() {
        byte[] data = new byte[]{1, 2, 3, 4, 5};
        byte[] changingData = new byte[data.length];
        System.arraycopy(data, 0, changingData, 0, data.length);
        MemorySegment segment = MemorySegmentFactory.wrapCopy((byte[])changingData, (int)0, (int)changingData.length);
        changingData[0] = (byte)(changingData[0] + 1);
        Assert.assertArrayEquals((byte[])data, (byte[])segment.getHeapMemory());
    }

    @Test
    public void testWrapPartialCopy() {
        byte[] data = new byte[]{1, 2, 3, 5, 6};
        MemorySegment segment = MemorySegmentFactory.wrapCopy((byte[])data, (int)0, (int)(data.length / 2));
        byte[] exp = new byte[segment.size()];
        System.arraycopy(data, 0, exp, 0, exp.length);
        Assert.assertArrayEquals((byte[])exp, (byte[])segment.getHeapMemory());
    }

    @Test
    public void testWrapCopyEmpty() {
        MemorySegmentFactory.wrapCopy((byte[])new byte[0], (int)0, (int)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrapCopyWrongStart() {
        MemorySegmentFactory.wrapCopy((byte[])new byte[]{1, 2, 3}, (int)10, (int)3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrapCopyWrongEnd() {
        MemorySegmentFactory.wrapCopy((byte[])new byte[]{1, 2, 3}, (int)0, (int)10);
    }
}

