/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentTestBase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OffHeapUnsafeMemorySegmentTest
extends MemorySegmentTestBase {
    public OffHeapUnsafeMemorySegmentTest(int pageSize) {
        super(pageSize);
    }

    @Override
    MemorySegment createSegment(int size) {
        return MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)size);
    }

    @Override
    MemorySegment createSegment(int size, Object owner) {
        return MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)size, (Object)owner, () -> {});
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testByteBufferWrapping() {
        this.createSegment(10).wrap(1, 2);
    }

    @Test
    public void testCallCleanerOnFree() {
        CompletableFuture cleanerFuture = new CompletableFuture();
        MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)10, null, () -> cleanerFuture.complete(null)).free();
        Assert.assertTrue((boolean)cleanerFuture.isDone());
    }

    @Test
    public void testCallCleanerOnceOnConcurrentFree() throws InterruptedException {
        AtomicInteger counter = new AtomicInteger(0);
        Runnable cleaner = () -> {
            try {
                counter.incrementAndGet();
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        };
        MemorySegment segment = MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)10, null, (Runnable)cleaner);
        Thread t1 = new Thread(() -> ((MemorySegment)segment).free());
        Thread t2 = new Thread(() -> ((MemorySegment)segment).free());
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        Assert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)1));
    }
}

