/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.nio.ByteBuffer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OnHeapMemorySegmentTest
extends MemorySegmentTestBase {
    public OnHeapMemorySegmentTest(int pageSize) {
        super(pageSize);
    }

    @Override
    MemorySegment createSegment(int size) {
        return MemorySegmentFactory.allocateUnpooledSegment((int)size);
    }

    @Override
    MemorySegment createSegment(int size, Object owner) {
        return MemorySegmentFactory.allocateUnpooledSegment((int)size, (Object)owner);
    }

    @Test
    public void testHeapSegmentSpecifics() {
        byte[] buffer = new byte[411];
        MemorySegment seg = new MemorySegment(buffer, null);
        Assert.assertFalse((boolean)seg.isFreed());
        Assert.assertFalse((boolean)seg.isOffHeap());
        Assert.assertEquals((long)buffer.length, (long)seg.size());
        Assert.assertTrue((buffer == seg.getArray() ? 1 : 0) != 0);
        ByteBuffer buf1 = seg.wrap(1, 2);
        ByteBuffer buf2 = seg.wrap(3, 4);
        Assert.assertTrue((buf1 != buf2 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)buf1.position());
        Assert.assertEquals((long)3L, (long)buf1.limit());
        Assert.assertEquals((long)3L, (long)buf2.position());
        Assert.assertEquals((long)7L, (long)buf2.limit());
    }

    @Test
    public void testReadOnlyByteBufferPut() {
        int i;
        byte[] buffer = new byte[100];
        MemorySegment seg = new MemorySegment(buffer, null);
        String content = "hello world";
        ByteBuffer bb = ByteBuffer.allocate(20);
        bb.put(content.getBytes());
        bb.rewind();
        int offset = 10;
        int numBytes = 5;
        ByteBuffer readOnlyBuf = bb.asReadOnlyBuffer();
        Assert.assertFalse((boolean)readOnlyBuf.isDirect());
        Assert.assertFalse((boolean)readOnlyBuf.hasArray());
        seg.put(offset, readOnlyBuf, numBytes);
        for (i = 0; i < offset; ++i) {
            Assert.assertEquals((long)0L, (long)buffer[i]);
        }
        Assert.assertEquals((Object)"hello", (Object)new String(buffer, offset, numBytes));
        for (i = offset + numBytes; i < buffer.length; ++i) {
            Assert.assertEquals((long)0L, (long)buffer[i]);
        }
    }
}

