/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.junit.Assert;
import org.junit.Test;

public class OperationsOnFreedSegmentTest {
    private static final int PAGE_SIZE = (int)(Math.random() * 10000.0 + 1000.0);

    @Test
    public void testSingleSegmentOperationsHeapSegment() throws Exception {
        for (MemorySegment segment : OperationsOnFreedSegmentTest.createTestSegments()) {
            this.testOpsOnFreedSegment(segment);
        }
    }

    @Test
    public void testCompare() {
        MemorySegment aliveHeap = MemorySegmentFactory.wrap((byte[])new byte[PAGE_SIZE]);
        MemorySegment aliveOffHeap = MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)PAGE_SIZE);
        MemorySegment freedHeap = MemorySegmentFactory.wrap((byte[])new byte[PAGE_SIZE]);
        MemorySegment freedOffHeap = MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)PAGE_SIZE);
        freedHeap.free();
        freedOffHeap.free();
        MemorySegment[] alive = new MemorySegment[]{aliveHeap, aliveOffHeap};
        MemorySegment[] free = new MemorySegment[]{freedHeap, freedOffHeap};
        for (MemorySegment seg1 : alive) {
            for (MemorySegment seg2 : free) {
                this.testCompare(seg1, seg2);
            }
        }
        for (MemorySegment seg1 : free) {
            for (MemorySegment seg2 : alive) {
                this.testCompare(seg1, seg2);
            }
        }
        for (MemorySegment seg1 : free) {
            for (MemorySegment seg2 : free) {
                this.testCompare(seg1, seg2);
            }
        }
    }

    @Test
    public void testCopyTo() {
        OperationsOnFreedSegmentTest.testAliveVsFree(this::testCopy);
    }

    @Test
    public void testSwap() {
        OperationsOnFreedSegmentTest.testAliveVsFree(this::testSwap);
    }

    private static void testAliveVsFree(BiConsumer<MemorySegment, MemorySegment> testOperation) {
        MemorySegment[] free;
        MemorySegment[] alive = OperationsOnFreedSegmentTest.createTestSegments();
        for (MemorySegment segment : free = OperationsOnFreedSegmentTest.createTestSegments()) {
            segment.free();
        }
        for (MemorySegment seg1 : alive) {
            for (MemorySegment seg2 : free) {
                testOperation.accept(seg1, seg2);
            }
        }
        for (MemorySegment seg1 : free) {
            for (MemorySegment seg2 : alive) {
                testOperation.accept(seg1, seg2);
            }
        }
        for (MemorySegment seg1 : free) {
            for (MemorySegment seg2 : free) {
                testOperation.accept(seg1, seg2);
            }
        }
    }

    private static MemorySegment[] createTestSegments() {
        MemorySegment heap = MemorySegmentFactory.wrap((byte[])new byte[PAGE_SIZE]);
        MemorySegment offHeap = MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)PAGE_SIZE);
        MemorySegment offHeapUnsafe = MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)PAGE_SIZE);
        MemorySegment[] segments = new MemorySegment[]{heap, offHeap, offHeapUnsafe};
        return segments;
    }

    private void testOpsOnFreedSegment(MemorySegment segment) throws Exception {
        segment.free();
        Assert.assertTrue((boolean)segment.isFreed());
        try {
            segment.get(0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get(-1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get(1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get(segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get(-segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get(Integer.MAX_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get(Integer.MIN_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put(0, (byte)0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put(-1, (byte)0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put(1, (byte)0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put(segment.size(), (byte)0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put(-segment.size(), (byte)0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put(Integer.MAX_VALUE, (byte)0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put(Integer.MIN_VALUE, (byte)0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.getBoolean(0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.getBoolean(-1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.getBoolean(1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.getBoolean(segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.getBoolean(-segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.getBoolean(Integer.MAX_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.getBoolean(Integer.MIN_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.putBoolean(0, true);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.putBoolean(-1, true);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.putBoolean(1, true);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.putBoolean(segment.size(), true);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.putBoolean(-segment.size(), true);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.putBoolean(Integer.MAX_VALUE, true);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.putBoolean(Integer.MIN_VALUE, true);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.getChar(0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getChar(-1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.getChar(1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getChar(segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getChar(-segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.getChar(Integer.MAX_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getChar(Integer.MIN_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putChar(0, 'a');
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putChar(-1, 'a');
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.putChar(1, 'a');
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putChar(segment.size(), 'a');
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putChar(-segment.size(), 'a');
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.putChar(Integer.MAX_VALUE, 'a');
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putChar(Integer.MIN_VALUE, 'a');
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getShort(0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getShort(-1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.getShort(1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getShort(segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getShort(-segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.getShort(Integer.MAX_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getShort(Integer.MIN_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putShort(0, (short)42);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putShort(-1, (short)42);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.putShort(1, (short)42);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putShort(segment.size(), (short)42);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putShort(-segment.size(), (short)42);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.putShort(Integer.MAX_VALUE, (short)42);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putShort(Integer.MIN_VALUE, (short)42);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getInt(0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getInt(-1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.getInt(1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getInt(segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getInt(-segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.getInt(Integer.MAX_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getInt(Integer.MIN_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putInt(0, 42);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putInt(-1, 42);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.putInt(1, 42);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putInt(segment.size(), 42);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putInt(-segment.size(), 42);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.putInt(Integer.MAX_VALUE, 42);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putInt(Integer.MIN_VALUE, 42);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getLong(0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getLong(-1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.getLong(1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getLong(segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getLong(-segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.getLong(Integer.MAX_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getLong(Integer.MIN_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putLong(0, 42L);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putLong(-1, 42L);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.putLong(1, 42L);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putLong(segment.size(), 42L);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putLong(-segment.size(), 42L);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.putLong(Integer.MAX_VALUE, 42L);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putLong(Integer.MIN_VALUE, 42L);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getFloat(0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getFloat(-1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.getFloat(1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getFloat(segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getFloat(-segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.getFloat(Integer.MAX_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getFloat(Integer.MIN_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putFloat(0, 42.0f);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putFloat(-1, 42.0f);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.putFloat(1, 42.0f);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putFloat(segment.size(), 42.0f);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putFloat(-segment.size(), 42.0f);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.putFloat(Integer.MAX_VALUE, 42.0f);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putFloat(Integer.MIN_VALUE, 42.0f);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getDouble(0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getDouble(-1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.getDouble(1);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getDouble(segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getDouble(-segment.size());
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.getDouble(Integer.MAX_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.getDouble(Integer.MIN_VALUE);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putDouble(0, 42.0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putDouble(-1, 42.0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.putDouble(1, 42.0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putDouble(segment.size(), 42.0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putDouble(-segment.size(), 42.0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            segment.putDouble(Integer.MAX_VALUE, 42.0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            segment.putDouble(Integer.MIN_VALUE, 42.0);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        byte[] array = new byte[55];
        try {
            segment.get(0, array, 3, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get(-1, array, 3, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get(1, array, 3, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get(segment.size(), array, 3, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get(-segment.size(), array, 3, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get(Integer.MAX_VALUE, array, 3, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get(Integer.MIN_VALUE, array, 3, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put(0, array, 3, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put(-1, array, 3, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put(1, array, 3, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put(segment.size(), array, 3, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put(-segment.size(), array, 3, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put(Integer.MAX_VALUE, array, 3, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put(Integer.MIN_VALUE, array, 3, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        for (ByteBuffer bbuf : new ByteBuffer[]{ByteBuffer.allocate(55), ByteBuffer.allocateDirect(55)}) {
            try {
                segment.get(0, bbuf, 17);
                Assert.fail((String)"Should fail with an exception");
            }
            catch (IllegalStateException | NullPointerException runtimeException) {
                // empty catch block
            }
            try {
                segment.get(-1, bbuf, 17);
                Assert.fail((String)"Should fail with an exception");
            }
            catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
                // empty catch block
            }
            try {
                segment.get(1, bbuf, 17);
                Assert.fail((String)"Should fail with an exception");
            }
            catch (IllegalStateException | NullPointerException runtimeException) {
                // empty catch block
            }
            try {
                segment.get(segment.size(), bbuf, 17);
                Assert.fail((String)"Should fail with an exception");
            }
            catch (IllegalStateException | NullPointerException runtimeException) {
                // empty catch block
            }
            try {
                segment.get(-segment.size(), bbuf, 17);
                Assert.fail((String)"Should fail with an exception");
            }
            catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
                // empty catch block
            }
            try {
                segment.get(Integer.MAX_VALUE, bbuf, 17);
                Assert.fail((String)"Should fail with an exception");
            }
            catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
                // empty catch block
            }
            try {
                segment.get(Integer.MIN_VALUE, bbuf, 17);
                Assert.fail((String)"Should fail with an exception");
            }
            catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
                // empty catch block
            }
            try {
                segment.put(0, bbuf, 17);
                Assert.fail((String)"Should fail with an exception");
            }
            catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
                // empty catch block
            }
            try {
                segment.put(-1, bbuf, 17);
                Assert.fail((String)"Should fail with an exception");
            }
            catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
                // empty catch block
            }
            try {
                segment.put(1, bbuf, 17);
                Assert.fail((String)"Should fail with an exception");
            }
            catch (IllegalStateException | NullPointerException runtimeException) {
                // empty catch block
            }
            try {
                segment.put(segment.size(), bbuf, 17);
                Assert.fail((String)"Should fail with an exception");
            }
            catch (IllegalStateException | NullPointerException runtimeException) {
                // empty catch block
            }
            try {
                segment.put(-segment.size(), bbuf, 17);
                Assert.fail((String)"Should fail with an exception");
            }
            catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
                // empty catch block
            }
            try {
                segment.put(Integer.MAX_VALUE, bbuf, 17);
                Assert.fail((String)"Should fail with an exception");
            }
            catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
                // empty catch block
            }
            try {
                segment.put(Integer.MIN_VALUE, bbuf, 17);
                Assert.fail((String)"Should fail with an exception");
            }
            catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(new byte[100]));
        DataOutputStream dout = new DataOutputStream(new ByteArrayOutputStream());
        try {
            segment.get((DataOutput)dout, 0, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get((DataOutput)dout, -1, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get((DataOutput)dout, 1, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get((DataOutput)dout, segment.size(), 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get((DataOutput)dout, -segment.size(), 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get((DataOutput)dout, Integer.MAX_VALUE, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.get((DataOutput)dout, Integer.MIN_VALUE, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put((DataInput)din, 0, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put((DataInput)din, -1, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put((DataInput)din, 1, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put((DataInput)din, segment.size(), 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put((DataInput)din, -segment.size(), 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put((DataInput)din, Integer.MAX_VALUE, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        try {
            segment.put((DataInput)din, Integer.MIN_VALUE, 17);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    private void testCompare(MemorySegment seg1, MemorySegment seg2) {
        int[] offsetsToTest = new int[]{0, 1, -1, seg1.size(), -seg1.size(), Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] lengthsToTest = new int[]{1, seg1.size(), Integer.MAX_VALUE};
        for (int off1 : offsetsToTest) {
            for (int off2 : offsetsToTest) {
                for (int len : lengthsToTest) {
                    try {
                        seg1.compare(seg2, off1, off2, len);
                        Assert.fail((String)"Should fail with an exception");
                    }
                    catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void testCopy(MemorySegment seg1, MemorySegment seg2) {
        int[] offsetsToTest = new int[]{0, 1, -1, seg1.size(), -seg1.size(), Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] lengthsToTest = new int[]{0, 1, -1, seg1.size(), -seg1.size(), Integer.MAX_VALUE, Integer.MIN_VALUE};
        for (int off1 : offsetsToTest) {
            for (int off2 : offsetsToTest) {
                for (int len : lengthsToTest) {
                    try {
                        seg1.copyTo(off1, seg2, off2, len);
                        Assert.fail((String)"Should fail with an exception");
                    }
                    catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void testSwap(MemorySegment seg1, MemorySegment seg2) {
        int[] offsetsToTest = new int[]{0, 1, -1, seg1.size(), -seg1.size(), Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] lengthsToTest = new int[]{0, 1, -1, seg1.size(), -seg1.size(), Integer.MAX_VALUE, Integer.MIN_VALUE};
        byte[] swapBuffer = new byte[seg1.size()];
        for (int off1 : offsetsToTest) {
            for (int off2 : offsetsToTest) {
                for (int len : lengthsToTest) {
                    try {
                        seg1.swapBytes(swapBuffer, seg2, off1, off2, len);
                        Assert.fail((String)"Should fail with an exception");
                    }
                    catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException runtimeException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

