/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.security;

import java.security.Permission;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.security.FlinkSecurityManager;
import org.apache.flink.core.security.UserSystemExitException;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.testutils.executor.TestExecutorResource;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class FlinkSecurityManagerTest
extends TestLogger {
    @ClassRule
    public static final TestExecutorResource<ExecutorService> EXECUTOR_RESOURCE = new TestExecutorResource(() -> Executors.newSingleThreadExecutor());
    private static final int TEST_EXIT_CODE = 123;
    SecurityManager originalSecurityManager;

    @Before
    public void setUp() {
        this.originalSecurityManager = System.getSecurityManager();
    }

    @After
    public void tearDown() {
        System.setSecurityManager(this.originalSecurityManager);
    }

    @Test(expected=UserSystemExitException.class)
    public void testThrowUserExit() {
        FlinkSecurityManager flinkSecurityManager = new FlinkSecurityManager(ClusterOptions.UserSystemExitMode.THROW, false);
        flinkSecurityManager.monitorUserSystemExit();
        flinkSecurityManager.checkExit(123);
    }

    @Test
    public void testToggleUserExit() {
        FlinkSecurityManager flinkSecurityManager = new FlinkSecurityManager(ClusterOptions.UserSystemExitMode.THROW, false);
        flinkSecurityManager.checkExit(123);
        flinkSecurityManager.monitorUserSystemExit();
        try {
            flinkSecurityManager.checkExit(123);
            Assert.fail();
        }
        catch (UserSystemExitException userSystemExitException) {
            // empty catch block
        }
        flinkSecurityManager.unmonitorUserSystemExit();
        flinkSecurityManager.checkExit(123);
    }

    @Test
    public void testPerThreadThrowUserExit() throws Exception {
        FlinkSecurityManager flinkSecurityManager = new FlinkSecurityManager(ClusterOptions.UserSystemExitMode.THROW, false);
        ExecutorService executorService = EXECUTOR_RESOURCE.getExecutor();
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> flinkSecurityManager.checkExit(123), executorService);
        future.get();
        flinkSecurityManager.monitorUserSystemExit();
        try {
            flinkSecurityManager.checkExit(123);
            Assert.fail();
        }
        catch (UserSystemExitException userSystemExitException) {
            // empty catch block
        }
        future = CompletableFuture.runAsync(() -> flinkSecurityManager.checkExit(123), executorService);
        future.get();
    }

    @Test
    public void testInheritedThrowUserExit() throws Exception {
        final FlinkSecurityManager flinkSecurityManager = new FlinkSecurityManager(ClusterOptions.UserSystemExitMode.THROW, false);
        flinkSecurityManager.monitorUserSystemExit();
        try {
            flinkSecurityManager.checkExit(123);
            Assert.fail();
        }
        catch (UserSystemExitException userSystemExitException) {
            // empty catch block
        }
        CheckedThread thread = new CheckedThread(){

            public void go() {
                try {
                    flinkSecurityManager.checkExit(123);
                    Assert.fail();
                }
                catch (UserSystemExitException userSystemExitException) {
                }
                catch (Throwable t) {
                    Assert.fail();
                }
            }
        };
        thread.start();
        thread.sync();
    }

    @Test
    public void testLogUserExit() {
        FlinkSecurityManager flinkSecurityManager = new FlinkSecurityManager(ClusterOptions.UserSystemExitMode.LOG, false);
        flinkSecurityManager.monitorUserSystemExit();
        flinkSecurityManager.checkExit(123);
    }

    @Test
    public void testDisabledConfiguration() {
        Configuration configuration = new Configuration();
        FlinkSecurityManager flinkSecurityManager = FlinkSecurityManager.fromConfiguration((Configuration)configuration);
        Assert.assertNull((Object)flinkSecurityManager);
        configuration.set(ClusterOptions.INTERCEPT_USER_SYSTEM_EXIT, (Object)ClusterOptions.UserSystemExitMode.DISABLED);
        flinkSecurityManager = FlinkSecurityManager.fromConfiguration((Configuration)configuration);
        Assert.assertNull((Object)flinkSecurityManager);
        configuration.set(ClusterOptions.HALT_ON_FATAL_ERROR, (Object)false);
        flinkSecurityManager = FlinkSecurityManager.fromConfiguration((Configuration)configuration);
        Assert.assertNull((Object)flinkSecurityManager);
    }

    @Test
    public void testLogConfiguration() {
        Configuration configuration = new Configuration();
        configuration.set(ClusterOptions.INTERCEPT_USER_SYSTEM_EXIT, (Object)ClusterOptions.UserSystemExitMode.LOG);
        FlinkSecurityManager flinkSecurityManager = FlinkSecurityManager.fromConfiguration((Configuration)configuration);
        Assert.assertNotNull((Object)flinkSecurityManager);
        Assert.assertFalse((boolean)flinkSecurityManager.userSystemExitMonitored());
        flinkSecurityManager.monitorUserSystemExit();
        Assert.assertTrue((boolean)flinkSecurityManager.userSystemExitMonitored());
        flinkSecurityManager.checkExit(123);
        flinkSecurityManager.unmonitorUserSystemExit();
        Assert.assertFalse((boolean)flinkSecurityManager.userSystemExitMonitored());
    }

    @Test
    public void testThrowConfiguration() {
        Configuration configuration = new Configuration();
        configuration.set(ClusterOptions.INTERCEPT_USER_SYSTEM_EXIT, (Object)ClusterOptions.UserSystemExitMode.THROW);
        FlinkSecurityManager flinkSecurityManager = FlinkSecurityManager.fromConfiguration((Configuration)configuration);
        Assert.assertNotNull((Object)flinkSecurityManager);
        Assert.assertFalse((boolean)flinkSecurityManager.userSystemExitMonitored());
        flinkSecurityManager.monitorUserSystemExit();
        Assert.assertTrue((boolean)flinkSecurityManager.userSystemExitMonitored());
        try {
            flinkSecurityManager.checkExit(123);
            Assert.fail();
        }
        catch (UserSystemExitException userSystemExitException) {
            // empty catch block
        }
        flinkSecurityManager.unmonitorUserSystemExit();
        Assert.assertFalse((boolean)flinkSecurityManager.userSystemExitMonitored());
        flinkSecurityManager = new FlinkSecurityManager(ClusterOptions.UserSystemExitMode.DISABLED, false);
        flinkSecurityManager.monitorUserSystemExit();
        Assert.assertTrue((boolean)flinkSecurityManager.userSystemExitMonitored());
        flinkSecurityManager.checkExit(123);
    }

    @Test
    public void testHaltConfiguration() {
        Configuration configuration = new Configuration();
        configuration.set(ClusterOptions.HALT_ON_FATAL_ERROR, (Object)true);
        FlinkSecurityManager flinkSecurityManager = FlinkSecurityManager.fromConfiguration((Configuration)configuration);
        Assert.assertNotNull((Object)flinkSecurityManager);
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidConfiguration() {
        Configuration configuration = new Configuration();
        configuration.set(ClusterOptions.INTERCEPT_USER_SYSTEM_EXIT, null);
        FlinkSecurityManager flinkSecurityManager = FlinkSecurityManager.fromConfiguration((Configuration)configuration);
    }

    @Test
    public void testExistingSecurityManagerRespected() {
        SecurityManager originalSecurityManager = new SecurityManager(){

            @Override
            public void checkPermission(Permission perm) {
                throw new SecurityException("not allowed");
            }
        };
        FlinkSecurityManager flinkSecurityManager = new FlinkSecurityManager(ClusterOptions.UserSystemExitMode.DISABLED, false, originalSecurityManager);
        CommonTestUtils.assertThrows((String)"not allowed", SecurityException.class, () -> {
            flinkSecurityManager.checkExit(123);
            return null;
        });
    }

    @Test
    public void testRegistrationNotAllowedByExistingSecurityManager() {
        Configuration configuration = new Configuration();
        configuration.set(ClusterOptions.INTERCEPT_USER_SYSTEM_EXIT, (Object)ClusterOptions.UserSystemExitMode.THROW);
        System.setSecurityManager(new SecurityManager(){
            private boolean fired;

            @Override
            public void checkPermission(Permission perm) {
                if (!this.fired && perm.getName().equals("setSecurityManager")) {
                    try {
                        throw new SecurityException("not allowed");
                    }
                    catch (Throwable throwable) {
                        this.fired = true;
                        throw throwable;
                    }
                }
            }
        });
        CommonTestUtils.assertThrows((String)"Could not register security manager", IllegalConfigurationException.class, () -> {
            FlinkSecurityManager.setFromConfiguration((Configuration)configuration);
            return null;
        });
    }

    @Test
    public void testMultiSecurityManagersWithSetFirstAndMonitored() {
        Configuration configuration = new Configuration();
        configuration.set(ClusterOptions.INTERCEPT_USER_SYSTEM_EXIT, (Object)ClusterOptions.UserSystemExitMode.THROW);
        configuration.set(ClusterOptions.HALT_ON_FATAL_ERROR, (Object)false);
        FlinkSecurityManager.setFromConfiguration((Configuration)configuration);
        TestExitSecurityManager newSecurityManager = new TestExitSecurityManager();
        System.setSecurityManager(newSecurityManager);
        FlinkSecurityManager.monitorUserSystemExitForCurrentThread();
        try {
            newSecurityManager.checkExit(123);
            Assert.fail((String)"Expect exception to be thrown");
        }
        catch (UserSystemExitException userSystemExitException) {
            // empty catch block
        }
        Assert.assertThat((Object)newSecurityManager.getExitStatus(), (Matcher)Matchers.is((Object)123));
    }

    @Test
    public void testMultiSecurityManagersWithSetLastAndMonitored() {
        Configuration configuration = new Configuration();
        configuration.set(ClusterOptions.INTERCEPT_USER_SYSTEM_EXIT, (Object)ClusterOptions.UserSystemExitMode.THROW);
        configuration.set(ClusterOptions.HALT_ON_FATAL_ERROR, (Object)false);
        TestExitSecurityManager oldSecurityManager = new TestExitSecurityManager();
        System.setSecurityManager(oldSecurityManager);
        FlinkSecurityManager.setFromConfiguration((Configuration)configuration);
        FlinkSecurityManager.monitorUserSystemExitForCurrentThread();
        try {
            System.getSecurityManager().checkExit(123);
            Assert.fail((String)"Expect exception to be thrown");
        }
        catch (UserSystemExitException userSystemExitException) {
            // empty catch block
        }
        Assert.assertNull((Object)oldSecurityManager.getExitStatus());
    }

    @Test
    public void testMultiSecurityManagersWithSetFirstAndUnmonitored() {
        Configuration configuration = new Configuration();
        configuration.set(ClusterOptions.INTERCEPT_USER_SYSTEM_EXIT, (Object)ClusterOptions.UserSystemExitMode.THROW);
        configuration.set(ClusterOptions.HALT_ON_FATAL_ERROR, (Object)false);
        FlinkSecurityManager.setFromConfiguration((Configuration)configuration);
        TestExitSecurityManager newSecurityManager = new TestExitSecurityManager();
        System.setSecurityManager(newSecurityManager);
        newSecurityManager.checkExit(123);
        Assert.assertThat((Object)newSecurityManager.getExitStatus(), (Matcher)Matchers.is((Object)123));
    }

    @Test
    public void testMultiSecurityManagersWithSetLastAndUnmonitored() {
        Configuration configuration = new Configuration();
        configuration.set(ClusterOptions.INTERCEPT_USER_SYSTEM_EXIT, (Object)ClusterOptions.UserSystemExitMode.THROW);
        configuration.set(ClusterOptions.HALT_ON_FATAL_ERROR, (Object)false);
        TestExitSecurityManager oldSecurityManager = new TestExitSecurityManager();
        System.setSecurityManager(oldSecurityManager);
        FlinkSecurityManager.setFromConfiguration((Configuration)configuration);
        System.getSecurityManager().checkExit(123);
        Assert.assertThat((Object)oldSecurityManager.getExitStatus(), (Matcher)Matchers.is((Object)123));
    }

    private class TestExitSecurityManager
    extends SecurityManager {
        private SecurityManager originalSecurityManager = System.getSecurityManager();
        private Integer exitStatus;

        @Override
        public void checkExit(int status) {
            this.exitStatus = status;
            if (this.originalSecurityManager != null) {
                this.originalSecurityManager.checkExit(status);
            }
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        public Integer getExitStatus() {
            return this.exitStatus;
        }
    }
}

