/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils;

import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class CustomEqualityMatcher
extends BaseMatcher<Object> {
    private final Object wanted;
    private final DeeplyEqualsChecker checker;

    private CustomEqualityMatcher(Object wanted, DeeplyEqualsChecker checker) {
        this.wanted = wanted;
        this.checker = checker;
    }

    public static CustomEqualityMatcher deeplyEquals(Object item) {
        return new CustomEqualityMatcher(item, new DeeplyEqualsChecker());
    }

    public CustomEqualityMatcher withChecker(DeeplyEqualsChecker checker) {
        return new CustomEqualityMatcher(this.wanted, checker);
    }

    public boolean matches(Object item) {
        return this.checker.deepEquals(item, this.wanted);
    }

    public void describeTo(Description description) {
        description.appendValue(this.wanted);
    }
}

