/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.parser.StringValueParser;
import org.junit.Assert;
import org.junit.Test;

public class VarLengthStringParserTest {
    public StringValueParser parser = new StringValueParser();

    @Test
    public void testGetValue() {
        StringValue v = this.parser.createValue();
        Assert.assertTrue((boolean)(v instanceof StringValue));
    }

    @Test
    public void testParseValidUnquotedStrings() {
        this.parser = new StringValueParser();
        byte[] recBytes = "abcdefgh|i|jklmno|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        StringValue s = new StringValue();
        int startPos = 0;
        Assert.assertTrue(((startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s)) == 9 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("abcdefgh"));
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 11 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("i"));
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 18 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("jklmno"));
        recBytes = "abcde".getBytes(ConfigConstants.DEFAULT_CHARSET);
        startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("abcde"));
        recBytes = "abcde|fg".getBytes(ConfigConstants.DEFAULT_CHARSET);
        startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("abcde"));
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 8 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("fg"));
    }

    @Test
    public void testParseValidQuotedStrings() {
        this.parser = new StringValueParser();
        this.parser.enableQuotedStringParsing((byte)34);
        byte[] recBytes = "\"abcdefgh\"|\"i\"|\"jklmno\"|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        StringValue s = new StringValue();
        int startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 11 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("abcdefgh"));
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 15 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("i"));
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 24 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("jklmno"));
        recBytes = "\"abcde\"".getBytes(ConfigConstants.DEFAULT_CHARSET);
        startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 7 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("abcde"));
        recBytes = "\"abcde\"|\"fg\"".getBytes(ConfigConstants.DEFAULT_CHARSET);
        startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 8 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("abcde"));
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 12 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("fg"));
        recBytes = "\"abcde|fg\"|\"hij|kl|mn|op\"|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 11 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("abcde|fg"));
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 26 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("hij|kl|mn|op"));
        recBytes = "\"abcde|fg\"|\"hij|kl|mn|op\"".getBytes(ConfigConstants.DEFAULT_CHARSET);
        startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 11 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("abcde|fg"));
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 25 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("hij|kl|mn|op"));
    }

    @Test
    public void testParseValidMixedStrings() {
        this.parser = new StringValueParser();
        this.parser.enableQuotedStringParsing((byte)64);
        byte[] recBytes = "@abcde|gh@|@i@|jklmnopq|@rs@|tuv".getBytes(ConfigConstants.DEFAULT_CHARSET);
        StringValue s = new StringValue();
        int startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 11 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("abcde|gh"));
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 15 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("i"));
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 24 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("jklmnopq"));
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 29 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("rs"));
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos == 32 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.getValue().equals("tuv"));
    }

    @Test
    public void testParseInvalidQuotedStrings() {
        this.parser = new StringValueParser();
        this.parser.enableQuotedStringParsing((byte)34);
        byte[] recBytes = "\"abcdefgh\"-|\"jklmno  ".getBytes(ConfigConstants.DEFAULT_CHARSET);
        StringValue s = new StringValue();
        int startPos = 0;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos < 0 ? 1 : 0) != 0);
        startPos = 12;
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertTrue((startPos < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testParseValidMixedStringsWithCharset() {
        Charset charset = StandardCharsets.US_ASCII;
        this.parser = new StringValueParser();
        this.parser.enableQuotedStringParsing((byte)64);
        byte[] recBytes = "@abcde|gh@|@i@|jklmnopq|@rs@|tuv".getBytes(ConfigConstants.DEFAULT_CHARSET);
        StringValue s = new StringValue();
        int startPos = 0;
        this.parser.setCharset(charset);
        startPos = this.parser.parseField(recBytes, startPos, recBytes.length, new byte[]{124}, s);
        Assert.assertEquals((long)11L, (long)startPos);
        Assert.assertEquals((Object)"abcde|gh", (Object)s.getValue());
    }
}

