/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
public class CollectionUtilTest {
    @Test
    public void testPartition() {
        List<Integer> list = Arrays.asList(1, 2, 3, 4);
        Collection partitioned = CollectionUtil.partition(list, (int)4);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)partitioned).as("List partitioned into the an incorrect number of partitions", new Object[0])).hasSize(4);
        Assertions.assertThat((Collection)partitioned).allSatisfy(partition -> {
            ListAssert cfr_ignored_0 = (ListAssert)Assertions.assertThat((List)partition).hasSize(1);
        });
    }

    @Test
    public void testOfNullableWithNull() {
        Assertions.assertThat((Collection)CollectionUtil.ofNullable(null)).isEmpty();
    }

    @Test
    public void testFromNullableWithObject() {
        Object element = new Object();
        ((ObjectAssert)Assertions.assertThat((Collection)CollectionUtil.ofNullable((Object)element)).singleElement()).isEqualTo(element);
    }

    @Test
    public void testComputeCapacity() {
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)CollectionUtil.computeRequiredCapacity((int)0, (float)0.75f));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)CollectionUtil.computeRequiredCapacity((int)1, (float)0.75f));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)CollectionUtil.computeRequiredCapacity((int)2, (float)0.75f));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)CollectionUtil.computeRequiredCapacity((int)3, (float)0.75f));
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)CollectionUtil.computeRequiredCapacity((int)4, (float)0.75f));
        org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)CollectionUtil.computeRequiredCapacity((int)5, (float)0.75f));
        org.junit.jupiter.api.Assertions.assertEquals((int)8, (int)CollectionUtil.computeRequiredCapacity((int)6, (float)0.75f));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)CollectionUtil.computeRequiredCapacity((int)7, (float)0.75f));
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)CollectionUtil.computeRequiredCapacity((int)8, (float)0.75f));
        org.junit.jupiter.api.Assertions.assertEquals((int)134, (int)CollectionUtil.computeRequiredCapacity((int)100, (float)0.75f));
        org.junit.jupiter.api.Assertions.assertEquals((int)1334, (int)CollectionUtil.computeRequiredCapacity((int)1000, (float)0.75f));
        org.junit.jupiter.api.Assertions.assertEquals((int)13334, (int)CollectionUtil.computeRequiredCapacity((int)10000, (float)0.75f));
        org.junit.jupiter.api.Assertions.assertEquals((int)20000, (int)CollectionUtil.computeRequiredCapacity((int)10000, (float)0.5f));
        org.junit.jupiter.api.Assertions.assertEquals((int)100000, (int)CollectionUtil.computeRequiredCapacity((int)10000, (float)0.1f));
        org.junit.jupiter.api.Assertions.assertEquals((int)0x55555580, (int)CollectionUtil.computeRequiredCapacity((int)0x3FFFFFFF, (float)0.75f));
        org.junit.jupiter.api.Assertions.assertEquals((int)Integer.MAX_VALUE, (int)CollectionUtil.computeRequiredCapacity((int)0x40000000, (float)0.75f));
        try {
            CollectionUtil.computeRequiredCapacity((int)-1, (float)0.75f);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            CollectionUtil.computeRequiredCapacity((int)Integer.MIN_VALUE, (float)0.75f);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

