/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.util.LongValueSequenceIterator;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class LongValueSequenceIteratorTest
extends TestLogger {
    @Test
    public void testSplitRegular() {
        LongValueSequenceIteratorTest.testSplitting(new LongValueSequenceIterator(0L, 10L), 2);
        LongValueSequenceIteratorTest.testSplitting(new LongValueSequenceIterator(100L, 100000L), 7);
        LongValueSequenceIteratorTest.testSplitting(new LongValueSequenceIterator(-100L, 0L), 5);
        LongValueSequenceIteratorTest.testSplitting(new LongValueSequenceIterator(-100L, 100L), 3);
    }

    @Test
    public void testSplittingLargeRangesBy2() {
        LongValueSequenceIteratorTest.testSplitting(new LongValueSequenceIterator(0L, Long.MAX_VALUE), 2);
        LongValueSequenceIteratorTest.testSplitting(new LongValueSequenceIterator(-1000000000L, Long.MAX_VALUE), 2);
        LongValueSequenceIteratorTest.testSplitting(new LongValueSequenceIterator(Long.MIN_VALUE, Long.MAX_VALUE), 2);
    }

    @Test
    public void testSplittingTooSmallRanges() {
        LongValueSequenceIteratorTest.testSplitting(new LongValueSequenceIterator(0L, 0L), 2);
        LongValueSequenceIteratorTest.testSplitting(new LongValueSequenceIterator(-5L, -5L), 2);
        LongValueSequenceIteratorTest.testSplitting(new LongValueSequenceIterator(-5L, -4L), 3);
        LongValueSequenceIteratorTest.testSplitting(new LongValueSequenceIterator(10L, 15L), 10);
    }

    private static void testSplitting(LongValueSequenceIterator iter, int numSplits) {
        LongValueSequenceIterator[] splits = iter.split(numSplits);
        Assert.assertEquals((long)numSplits, (long)splits.length);
        Assert.assertEquals((long)iter.getCurrent(), (long)splits[0].getCurrent());
        Assert.assertEquals((long)iter.getTo(), (long)splits[numSplits - 1].getTo());
        for (int i = 1; i < splits.length; ++i) {
            Assert.assertEquals((long)(splits[i - 1].getTo() + 1L), (long)splits[i].getCurrent());
        }
        LongValueSequenceIteratorTest.testMaxSplitDiff(splits);
    }

    private static void testMaxSplitDiff(LongValueSequenceIterator[] iters) {
        long minSplitSize = Long.MAX_VALUE;
        long maxSplitSize = Long.MIN_VALUE;
        for (LongValueSequenceIterator iter : iters) {
            long diff = iter.getTo() < iter.getCurrent() ? 0L : iter.getTo() - iter.getCurrent();
            if (diff < 0L) {
                diff = Long.MAX_VALUE;
            }
            minSplitSize = Math.min(minSplitSize, diff);
            maxSplitSize = Math.max(maxSplitSize, diff);
        }
        Assert.assertTrue((maxSplitSize == minSplitSize || maxSplitSize - 1L == minSplitSize ? 1 : 0) != 0);
    }
}

