/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.SerializedValue;
import org.junit.Assert;
import org.junit.Test;

public class SerializedValueTest {
    @Test
    public void testSimpleValue() {
        try {
            String value = "teststring";
            SerializedValue v = new SerializedValue((Object)"teststring");
            SerializedValue copy = (SerializedValue)CommonTestUtils.createCopySerializable((Serializable)v);
            Assert.assertEquals((Object)"teststring", (Object)v.deserializeValue(this.getClass().getClassLoader()));
            Assert.assertEquals((Object)"teststring", (Object)copy.deserializeValue(this.getClass().getClassLoader()));
            Assert.assertEquals((Object)v, (Object)copy);
            Assert.assertEquals((long)v.hashCode(), (long)copy.hashCode());
            Assert.assertNotNull((Object)v.toString());
            Assert.assertNotNull((Object)copy.toString());
            Assert.assertNotEquals((long)0L, (long)v.getByteArray().length);
            Assert.assertArrayEquals((byte[])v.getByteArray(), (byte[])copy.getByteArray());
            byte[] bytes = v.getByteArray();
            SerializedValue saved = SerializedValue.fromBytes((byte[])Arrays.copyOf(bytes, bytes.length));
            Assert.assertEquals((Object)v, (Object)saved);
            Assert.assertArrayEquals((byte[])v.getByteArray(), (byte[])saved.getByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(expected=NullPointerException.class)
    public void testNullValue() throws Exception {
        new SerializedValue(null);
    }

    @Test(expected=NullPointerException.class)
    public void testFromNullBytes() {
        SerializedValue.fromBytes(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromEmptyBytes() {
        SerializedValue.fromBytes((byte[])new byte[0]);
    }
}

