/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.types.StringValue;
import org.apache.flink.util.StringValueUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class StringValueUtilsTest
extends TestLogger {
    @Test
    public void testToLowerCaseConverting() {
        StringValue testString = new StringValue((CharSequence)"TEST");
        StringValueUtils.toLowerCase((StringValue)testString);
        Assert.assertEquals((Object)new StringValue((CharSequence)"test"), (Object)testString);
    }

    @Test
    public void testReplaceNonWordChars() {
        StringValue testString = new StringValue((CharSequence)"TEST123_@");
        StringValueUtils.replaceNonWordChars((StringValue)testString, (char)'!');
        Assert.assertEquals((Object)new StringValue((CharSequence)"TEST123_!"), (Object)testString);
    }

    @Test
    public void testTokenizerOnStringWithoutNexToken() {
        StringValue testString = new StringValue((CharSequence)"test");
        StringValueUtils.WhitespaceTokenizer tokenizer = new StringValueUtils.WhitespaceTokenizer();
        tokenizer.setStringToTokenize(testString);
        tokenizer.next(testString);
        Assert.assertFalse((boolean)tokenizer.next(testString));
    }

    @Test
    public void testTokenizerOnStringWithNexToken() {
        StringValue testString = new StringValue((CharSequence)"test test");
        StringValueUtils.WhitespaceTokenizer tokenizer = new StringValueUtils.WhitespaceTokenizer();
        tokenizer.setStringToTokenize(testString);
        Assert.assertTrue((boolean)tokenizer.next(testString));
    }

    @Test
    public void testTokenizerOnStringOnlyWithDelimiter() {
        StringValue testString = new StringValue((CharSequence)"    ");
        StringValueUtils.WhitespaceTokenizer tokenizer = new StringValueUtils.WhitespaceTokenizer();
        tokenizer.setStringToTokenize(testString);
        Assert.assertFalse((boolean)tokenizer.next(testString));
    }
}

