/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.util.WrappingProxy;
import org.apache.flink.util.WrappingProxyUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class WrappingProxyUtilTest {
    @Test
    public void testThrowsExceptionIfTooManyProxies() {
        try {
            WrappingProxyUtil.stripProxy((WrappingProxy)new SelfWrappingProxy(128));
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Are there loops in the object graph?"));
        }
    }

    @Test
    public void testStripsAllProxies() {
        SelfWrappingProxy wrappingProxy = new SelfWrappingProxy(127);
        Assert.assertThat((Object)WrappingProxyUtil.stripProxy((WrappingProxy)wrappingProxy), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(SelfWrappingProxy.class))));
    }

    private static class SelfWrappingProxy
    extends Wrapped
    implements WrappingProxy<Wrapped> {
        private int levels;

        private SelfWrappingProxy(int levels) {
            this.levels = levels;
        }

        public Wrapped getWrappedDelegate() {
            if (this.levels-- == 0) {
                return new Wrapped();
            }
            return this;
        }
    }

    private static class Wrapped {
        private Wrapped() {
        }
    }
}

