/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util.concurrent;

import java.time.Duration;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.FixedRetryStrategy;
import org.apache.flink.util.concurrent.RetryStrategy;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FixedRetryStrategyTest
extends TestLogger {
    @Test
    public void testGetters() {
        FixedRetryStrategy retryStrategy = new FixedRetryStrategy(10, Duration.ofMillis(5L));
        Assertions.assertThat((int)retryStrategy.getNumRemainingRetries()).isEqualTo(10);
        Assertions.assertThat((Duration)retryStrategy.getRetryDelay()).isEqualTo((Object)Duration.ofMillis(5L));
        RetryStrategy nextRetryStrategy = retryStrategy.getNextRetryStrategy();
        Assertions.assertThat((int)nextRetryStrategy.getNumRemainingRetries()).isEqualTo(9);
        Assertions.assertThat((Duration)nextRetryStrategy.getRetryDelay()).isEqualTo((Object)Duration.ofMillis(5L));
    }

    @Test
    public void testRetryFailure() {
        Assertions.assertThatThrownBy(() -> new FixedRetryStrategy(0, Duration.ofMillis(5L)).getNextRetryStrategy()).isInstanceOf(IllegalStateException.class);
    }
}

