/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.LongMinimum;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class LongMinimumTest {
    LongMinimumTest() {
    }

    @Test
    void testGet() {
        LongMinimum min = new LongMinimum();
        Assertions.assertThat((long)min.getLocalValue()).isEqualTo(Long.MAX_VALUE);
    }

    @Test
    void testResetLocal() {
        LongMinimum min = new LongMinimum();
        long value = 9876543210L;
        min.add(value);
        Assertions.assertThat((long)min.getLocalValue()).isEqualTo(value);
        min.resetLocal();
        Assertions.assertThat((long)min.getLocalValue()).isEqualTo(Long.MAX_VALUE);
    }

    @Test
    void testAdd() {
        LongMinimum min = new LongMinimum();
        min.add(1234567890L);
        min.add(9876543210L);
        min.add(-9876543210L);
        min.add(-1234567890L);
        Assertions.assertThat((long)min.getLocalValue()).isEqualTo(-9876543210L);
    }

    @Test
    void testMerge() {
        LongMinimum min1 = new LongMinimum();
        min1.add(1234567890987654321L);
        LongMinimum min2 = new LongMinimum();
        min2.add(5678909876543210123L);
        min2.merge((Accumulator)min1);
        Assertions.assertThat((long)min2.getLocalValue()).isEqualTo(1234567890987654321L);
        min1.merge((Accumulator)min2);
        Assertions.assertThat((long)min1.getLocalValue()).isEqualTo(1234567890987654321L);
    }

    @Test
    void testClone() {
        LongMinimum min = new LongMinimum();
        long value = 4242424242424242L;
        min.add(value);
        LongMinimum clone = min.clone();
        Assertions.assertThat((long)clone.getLocalValue()).isEqualTo(value);
    }
}

